/*
 * Decompiled with CFR 0.152.
 */
package FileUtilities;

import FileUtilities.FileOperations;
import RuntimeTool.DebugManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public abstract class PropertiesFile {
    private final Properties mProperties = new Properties();
    private final File mFile;
    private final String mDescription;

    public PropertiesFile(File file, String string) {
        this.mFile = file;
        this.mDescription = string;
    }

    protected abstract void validate() throws MissingPropertiesException;

    protected void requiredKey(String string) throws MissingPropertiesException {
        if (!this.mProperties.containsKey(string)) {
            throw new MissingPropertiesException(string);
        }
    }

    protected void requiredKeys(String[] stringArray) throws MissingPropertiesException {
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            this.requiredKey(stringArray[i2]);
        }
    }

    public File getFile() {
        return this.mFile;
    }

    protected Properties getProperties() {
        return this.mProperties;
    }

    public boolean hasFile() {
        try {
            return this.getFile() != null && this.getFile().exists() && this.getFile().canRead();
        }
        catch (Exception exception) {
            DebugManager.getDefault().printException("Error getting the config file", exception);
            return false;
        }
    }

    public void load() throws IOException, MissingPropertiesException {
        FileInputStream fileInputStream = new FileInputStream(this.getFile());
        this.mProperties.load(fileInputStream);
        fileInputStream.close();
        try {
            this.validate();
        }
        catch (MissingPropertiesException missingPropertiesException) {
            this.mProperties.clear();
            throw missingPropertiesException;
        }
    }

    public void storeNewFile() throws IOException {
        if (!this.getFile().exists()) {
            this.getFile().createNewFile();
        }
        this.store(this.getFile());
    }

    public void store() throws IOException {
        if (!this.getFile().exists()) {
            throw new FileNotFoundException("Not allowed to create new properties file");
        }
        this.store(this.getFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(File file) throws IOException {
        File file2 = File.createTempFile("tempProperties", null, file.getAbsoluteFile().getParentFile());
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            this.mProperties.store(fileOutputStream, this.mDescription);
            fileOutputStream.close();
            if (!FileOperations.atomicReplace(file2, file)) {
                throw new IOException("Failed to update properties file [" + file + "]");
            }
        }
        finally {
            file2.delete();
        }
    }

    public static class MissingPropertiesException
    extends Exception {
        MissingPropertiesException(String string) {
            super(string);
        }
    }
}

