/*
 * Decompiled with CFR 0.152.
 */
package FileUtilities;

import DateUtilities.DateStringBuilder;
import FileUtilities.FileOperations;
import RuntimeTool.DebugManager;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class DirectoryLock {
    private static final String LOCK_FILENAME = "imsdir.lck";
    private static Map mDirectoryLockMap = new LinkedHashMap();
    private final File mDirectory;
    private final RandomAccessFile mLockHandle;
    private final FileLock mLock;
    private final Throwable mCaller = new Throwable("Synthetic Exception");

    public static synchronized DirectoryLock tryLock(File file, String string) throws IOException {
        DirectoryLock.removeNullEntries();
        if (DirectoryLock.lookupDirectoryLock(file) != null) {
            return null;
        }
        DirectoryLock directoryLock = DirectoryLock.tryFileLock(file, string);
        if (directoryLock == null) {
            return null;
        }
        mDirectoryLockMap.put(file, new WeakReference<DirectoryLock>(directoryLock));
        return directoryLock;
    }

    static synchronized List getLockedDirectories() {
        DirectoryLock.removeNullEntries();
        return new ArrayList(mDirectoryLockMap.keySet());
    }

    static synchronized DirectoryLock lookupDirectoryLock(File file) {
        WeakReference weakReference = (WeakReference)mDirectoryLockMap.get(file);
        if (weakReference == null) {
            return null;
        }
        return (DirectoryLock)weakReference.get();
    }

    private static synchronized void removeLock(File file) {
        mDirectoryLockMap.remove(file);
    }

    private static synchronized void removeNullEntries() {
        Iterator iterator = mDirectoryLockMap.values().iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            if (weakReference.get() != null) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirectoryLock tryFileLock(File file, String string) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("Cannot lock non-directory: " + file);
        }
        if (!file.isDirectory()) {
            throw new IOException("Could not get a lock, directory does not exist: " + file);
        }
        File file2 = new File(file, LOCK_FILENAME);
        RandomAccessFile randomAccessFile = new RandomAccessFile(file2, "rw");
        boolean bl2 = true;
        try {
            FileLock fileLock = randomAccessFile.getChannel().tryLock();
            if (fileLock == null || !fileLock.isValid()) {
                DirectoryLock directoryLock = null;
                return directoryLock;
            }
            DirectoryLock directoryLock = new DirectoryLock(file, randomAccessFile, fileLock);
            directoryLock.writeInitialMessage(string);
            bl2 = false;
            DirectoryLock directoryLock2 = directoryLock;
            return directoryLock2;
        }
        finally {
            if (bl2) {
                randomAccessFile.close();
            }
        }
    }

    private DirectoryLock(File file, RandomAccessFile randomAccessFile, FileLock fileLock) {
        this.mDirectory = file;
        this.mLockHandle = randomAccessFile;
        this.mLock = fileLock;
    }

    public File getDirectory() {
        return this.mDirectory;
    }

    public boolean lockForDirectory(File file) {
        return this.mLock.isValid() && this.mDirectory.equals(file);
    }

    public File getLockFile() {
        return new File(this.mDirectory, LOCK_FILENAME);
    }

    private void writeMessageLine(String string) {
        try {
            this.mLockHandle.writeBytes(string + FileOperations.LINE_SEPARATOR);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeInitialMessage(String string) {
        try {
            this.mLockHandle.setLength(0L);
            this.writeMessageLine("# DirectoryLock generated at " + DateStringBuilder.getCurrentDateTimeIso());
            if (string != null) {
                this.writeMessageLine("# " + string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void release() {
        if (!this.mLockHandle.getChannel().isOpen()) {
            return;
        }
        try {
            this.writeMessageLine("# DirectoryLock released at " + DateStringBuilder.getCurrentDateTimeIso());
            this.mLockHandle.close();
        }
        catch (IOException iOException) {
            DebugManager.getDefault().printException("Error closing lock file " + this + ": " + iOException.toString(), iOException);
        }
        DirectoryLock.removeLock(this.mDirectory);
    }

    protected void finalize() throws Throwable {
        if (this.mLockHandle.getChannel().isOpen()) {
            DebugManager.getDefault().printException("Finalizing valid " + this + ", created in following context", this.mCaller);
        }
        this.release();
        super.finalize();
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.mDirectory + " [" + this.mLock + "]";
    }
}

