/*
 * Decompiled with CFR 0.152.
 */
package DataModels.UserModels;

import DataModels.AbstractDataModel;
import DataModels.UserModels.ModificationTracked;
import DataModels.UserModels.Password;
import DataModels.UserModels.Privilege;
import DataModels.UserModels.PrivilegeSet;
import DataModels.UserModels.Privileged;
import DataModels.UserModels.Role;
import DataModels.UserModels.UserProperty;
import StringUtilities.StringCheck;
import StringUtilities.ToString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.enums.Enum;

public class User
extends AbstractDataModel
implements Privileged,
ModificationTracked {
    public static final int NEW_USER_ID = -1;
    public static final int UNDEFINED_SESSION_TIMEOUT = -1;
    public static final int DEFAULT_PASSWORD_LIFETIME = 90;
    public static final int INITIAL_GRACE_LOGINS = 5;
    private int mUserId = -1;
    private String mUsername;
    private AccountType mAccountType = AccountType.LOCAL;
    private String mExternalId;
    private boolean mInteleradUser;
    private State mState = State.NORMAL;
    private String mFirstName;
    private String mMiddleName;
    private String mLastName;
    private String mEmail;
    private String mTelephone1;
    private String mTelephone2;
    private String mTitle;
    private String mDepartment;
    private String mAddress;
    private String mRisId;
    private String mAutoLinkId;
    private String mEmployeeId;
    private String mHospitalId;
    private int mSessionTimeout = -1;
    private int mPasswordLifetime = 0;
    private Date mAccountExpiry = null;
    private int mGraceLoginsLeft = 0;
    private int mFailedLogins = 0;
    private Date mCreateTime;
    private String mCreateSource;
    private Date mModifyTime;
    private String mModifySource;
    private List mPasswords = null;
    private Set mOrganizations = null;
    private boolean mAcceptedTerms = false;
    private boolean mDeleted = false;
    private Map mPreferences = null;
    private Set mUserPrivileges = null;
    private Set mRoles = null;
    private Set mAccessibleOrders = null;
    public static final int ACCOUNT_EXPIRING_SOON_HOURS = 144;
    public static final int ACCOUNT_EXPIRING_VERY_SOON_HOURS = 18;
    private static final UserProperty[] DEMOGRAPHIC_PROPERTIES = new UserProperty[]{UserProperty.FirstName, UserProperty.MiddleName, UserProperty.LastName, UserProperty.Email, UserProperty.Telephone1, UserProperty.Telephone2, UserProperty.Title, UserProperty.Department, UserProperty.Address, UserProperty.RisId, UserProperty.AutoLinkId, UserProperty.EmployeeId, UserProperty.HospitalId};
    static /* synthetic */ Class class$DataModels$UserModels$User$State;
    static /* synthetic */ Class class$DataModels$UserModels$User$AccountType;

    public User(int n2, String string) {
        this.mUserId = n2;
        this.setUsername(string);
    }

    public User(String string) {
        this(-1, string);
    }

    public User() {
        this(-1, null);
    }

    public User(User user, String string) {
        this.mUserId = user.mUserId;
        this.mUsername = string;
        this.mAccountType = user.mAccountType;
        this.mExternalId = user.mExternalId;
        this.mInteleradUser = user.mInteleradUser;
        this.mState = user.mState;
        this.mFirstName = user.mFirstName;
        this.mMiddleName = user.mMiddleName;
        this.mLastName = user.mLastName;
        this.mEmail = user.mEmail;
        this.mTelephone1 = user.mTelephone1;
        this.mTelephone2 = user.mTelephone2;
        this.mTitle = user.mTitle;
        this.mDepartment = user.mDepartment;
        this.mAddress = user.mAddress;
        this.mRisId = user.mRisId;
        this.mAutoLinkId = user.mAutoLinkId;
        this.mEmployeeId = user.mEmployeeId;
        this.mHospitalId = user.mHospitalId;
        this.mSessionTimeout = user.mSessionTimeout;
        this.mPasswordLifetime = user.mPasswordLifetime;
        this.mAccountExpiry = user.mAccountExpiry;
        this.mGraceLoginsLeft = user.mGraceLoginsLeft;
        this.mFailedLogins = user.mFailedLogins;
        this.mAcceptedTerms = user.mAcceptedTerms;
        this.mDeleted = user.mDeleted;
        this.mOrganizations = user.mOrganizations;
        this.mPreferences = user.mPreferences;
        this.mUserPrivileges = user.mUserPrivileges;
        this.mRoles = user.mRoles;
        this.mAccessibleOrders = user.mAccessibleOrders;
        this.mPasswords = user.mPasswords;
    }

    public void initialize() {
        this.initPreferences();
        this.initPrivileges();
        this.initOrganizations();
        this.initPasswords();
        this.setPasswordLifetime(90);
        this.setGraceLoginsLeft(5);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof User)) {
            return false;
        }
        User user = (User)object;
        return this.mUserId == user.mUserId && this.mUsername.equals(user.mUsername) && this.mInteleradUser == user.mInteleradUser;
    }

    public int hashCode() {
        return this.mUsername.hashCode() | this.mUserId;
    }

    public Collection getProperties() {
        return UserProperty.getProperties();
    }

    public static UserProperty[] getDemographicProperties() {
        return DEMOGRAPHIC_PROPERTIES;
    }

    public int getUserId() {
        return this.mUserId;
    }

    public int getId() {
        return this.mUserId;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public AccountType getAccountType() {
        return this.mAccountType;
    }

    public boolean isLocalUser() {
        return this.mAccountType.equals((Object)AccountType.LOCAL);
    }

    public boolean isLdapUser() {
        return this.mAccountType.equals((Object)AccountType.LDAP);
    }

    public boolean isInteleradUser() {
        return this.mInteleradUser;
    }

    public String getExternalId() {
        return this.mExternalId;
    }

    public State getState() {
        return this.mState;
    }

    public String getFirstName() {
        return this.mFirstName;
    }

    public String getMiddleName() {
        return this.mMiddleName;
    }

    public String getLastName() {
        return this.mLastName;
    }

    public String getUiString() {
        return this.getUiStringHelper(this.getFullName(false));
    }

    public String getSortableUiString() {
        return this.getUiStringHelper(this.getSortableFullName(false));
    }

    public String getEmail() {
        return this.mEmail;
    }

    public String getTelephone1() {
        return this.mTelephone1;
    }

    public String getTelephone2() {
        return this.mTelephone2;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getDepartment() {
        return this.mDepartment;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public String getRisId() {
        return this.mRisId;
    }

    public String getAutoLinkId() {
        return this.mAutoLinkId;
    }

    public String getEmployeeId() {
        return this.mEmployeeId;
    }

    public String getHospitalId() {
        return this.mHospitalId;
    }

    public int getSessionTimeout() {
        return this.mSessionTimeout;
    }

    public int getPasswordLifetime() {
        return this.mPasswordLifetime;
    }

    public int getGraceLoginsLeft() {
        return this.mGraceLoginsLeft;
    }

    public int getFailedLogins() {
        return this.mFailedLogins;
    }

    public int getNumberOfFailedLogins() {
        return this.getFailedLogins();
    }

    public Date getAccountExpiry() {
        return this.mAccountExpiry;
    }

    public boolean hasAcceptedTerms() {
        return this.mAcceptedTerms;
    }

    public Date getModifyTime() {
        return this.mModifyTime;
    }

    public String getModifySource() {
        return this.mModifySource;
    }

    public Date getCreateTime() {
        return this.mCreateTime;
    }

    public String getCreateSource() {
        return this.mCreateSource;
    }

    public Set getOrganizations() {
        this.checkOrganizations();
        return Collections.unmodifiableSet(this.mOrganizations);
    }

    public boolean hasOrganization(String string) {
        this.checkOrganizations();
        return this.mOrganizations.contains(string);
    }

    public boolean hasOrganizationRestrictions() {
        this.checkOrganizations();
        return !this.mOrganizations.isEmpty();
    }

    public boolean passwordMatches(String string) {
        this.checkPasswords();
        if (this.mPasswords.isEmpty()) {
            return false;
        }
        Password password = (Password)this.mPasswords.get(0);
        return password.passwordMatches(this.mUsername, string);
    }

    public List getPasswords() {
        this.checkPasswords();
        return Collections.unmodifiableList(this.mPasswords);
    }

    public boolean isPasswordExpired() {
        this.checkPasswords();
        if (this.mPasswords.isEmpty()) {
            return false;
        }
        return ((Password)this.mPasswords.get(0)).isExpired();
    }

    public Date getCurrentPasswordExpiry() {
        this.checkPasswords();
        Password password = (Password)this.mPasswords.get(0);
        return password.getExpiryDate();
    }

    public Locale getLocale() {
        String string = this.getPreference("locale");
        if (string == null) {
            return null;
        }
        return new Locale(string);
    }

    public Map getPreferences() {
        this.checkPreferences();
        return Collections.unmodifiableMap(this.mPreferences);
    }

    public String getPreference(String string) {
        this.checkPreferences();
        return (String)this.mPreferences.get(string);
    }

    public String getSearchField1() {
        return this.getPreference("search-field-1");
    }

    public String getSearchField2() {
        return this.getPreference("search-field-2");
    }

    public boolean hasPrivilege(Privilege privilege) {
        this.checkPrivileges();
        return this.mUserPrivileges.contains(privilege) || this.hasRolePrivilege(privilege);
    }

    private boolean hasRolePrivilege(Privilege privilege) {
        this.checkPrivileges();
        Iterator iterator = this.mRoles.iterator();
        while (iterator.hasNext()) {
            if (!((Role)iterator.next()).hasPrivilege(privilege)) continue;
            return true;
        }
        return false;
    }

    public Set getInherentPrivileges() {
        this.checkPrivileges();
        return Collections.unmodifiableSet(this.mUserPrivileges);
    }

    public Set getAcquiredPrivileges() {
        this.checkPrivileges();
        return Collections.unmodifiableSet(this.getRolePrivileges());
    }

    public Set getAllPrivileges() {
        this.checkPrivileges();
        HashSet hashSet = new HashSet(this.mUserPrivileges);
        hashSet.addAll(this.getRolePrivileges());
        return hashSet;
    }

    public Collection getUserPrivileges() {
        return this.getInherentPrivileges();
    }

    private Set getRolePrivileges() {
        this.checkPrivileges();
        HashSet hashSet = new HashSet();
        Iterator iterator = this.mRoles.iterator();
        while (iterator.hasNext()) {
            hashSet.addAll(((Role)iterator.next()).getInherentPrivileges());
        }
        return hashSet;
    }

    public int getUserGlobalPrivileges() {
        this.checkPrivileges();
        return PrivilegeSet.getInstance().getGlobalPrivilegeBitmap(this.mUserPrivileges);
    }

    public int getUserImagePrivileges() {
        this.checkPrivileges();
        return PrivilegeSet.getInstance().getImagePrivilegeBitmap(this.mUserPrivileges);
    }

    public int getUserReportPrivileges() {
        this.checkPrivileges();
        return PrivilegeSet.getInstance().getReportPrivilegeBitmap(this.mUserPrivileges);
    }

    public Set getAccessibleOrders() {
        this.checkAccessibleOrders();
        return new HashSet(this.mAccessibleOrders);
    }

    public boolean isOrderAccessible(String string) {
        this.checkAccessibleOrders();
        return this.mAccessibleOrders.contains(string);
    }

    public boolean isNormal() {
        return this.mState == State.NORMAL;
    }

    public boolean isPending() {
        return this.mState == State.PENDING;
    }

    public boolean isLocked() {
        return this.mState == State.LOCKED;
    }

    public boolean isDeleted() {
        return this.mDeleted;
    }

    public boolean isNew() {
        return this.getUserId() == -1;
    }

    public boolean isExpired() {
        return this.mAccountExpiry != null && new Date().after(this.mAccountExpiry);
    }

    public boolean isValid() {
        return this.isNormal() && !this.isExpired() && !this.isDeleted();
    }

    public Collection getRoles() {
        this.checkPrivileges();
        return new HashSet(this.mRoles);
    }

    public Collection getRoleNames() {
        this.checkPrivileges();
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator iterator = this.mRoles.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Role)iterator.next()).getRoleName());
        }
        return arrayList;
    }

    public boolean hasRole(String string) {
        this.checkPrivileges();
        Iterator iterator = this.mRoles.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            if (!role.getRoleName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(Role role) {
        this.checkPrivileges();
        return this.mRoles.contains(role);
    }

    public void setUserId(int n2) {
        if (this.mUserId != -1) {
            throw new IllegalStateException("user id is already set");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("invalid user id: " + n2);
        }
        this.mUserId = n2;
    }

    public void setUsername(String string) {
        if (this.mUsername != null) {
            throw new IllegalStateException("username is already set");
        }
        if (string != null) {
            string = string.trim();
        }
        this.mUsername = string;
    }

    public void setAccountType(AccountType accountType) {
        this.mAccountType = accountType;
    }

    public void setInteleradUser(boolean bl2) {
        if (bl2 && !this.mAccountType.equals((Object)AccountType.LOCAL)) {
            throw new IllegalStateException("Cannot set inteleradUser true: accountType != local");
        }
        this.mInteleradUser = bl2;
    }

    public void setExternalId(String string) {
        this.mExternalId = string;
    }

    public void setState(State state) {
        this.mState = state;
    }

    public boolean lock() {
        if (this.isNormal() && !this.isDeleted()) {
            this.setState(State.LOCKED);
            return true;
        }
        return false;
    }

    public boolean unlock() {
        if (this.isLocked() && !this.isDeleted()) {
            this.setState(State.NORMAL);
            return true;
        }
        return false;
    }

    public boolean delete() {
        if (!this.isDeleted()) {
            this.setDeleted(true);
            return true;
        }
        return false;
    }

    public boolean undelete() {
        if (this.isDeleted() && !this.isPending()) {
            this.setDeleted(false);
            return true;
        }
        return false;
    }

    public void setFirstName(String string) {
        this.mFirstName = string;
    }

    public void setMiddleName(String string) {
        this.mMiddleName = string;
    }

    public void setLastName(String string) {
        this.mLastName = string;
    }

    public void setEmail(String string) {
        this.mEmail = string;
    }

    public void setTelephone1(String string) {
        this.mTelephone1 = string;
    }

    public void setTelephone2(String string) {
        this.mTelephone2 = string;
    }

    public void setTitle(String string) {
        this.mTitle = string;
    }

    public void setDepartment(String string) {
        this.mDepartment = string;
    }

    public void setAddress(String string) {
        this.mAddress = string;
    }

    public void setRisId(String string) {
        this.mRisId = string;
    }

    public void setAutoLinkId(String string) {
        this.mAutoLinkId = string;
    }

    public void setEmployeeId(String string) {
        this.mEmployeeId = string;
    }

    public void setHospitalId(String string) {
        this.mHospitalId = string;
    }

    public void setSessionTimeout(int n2) {
        this.mSessionTimeout = n2;
    }

    public void setGraceLoginsLeft(int n2) {
        this.mGraceLoginsLeft = n2;
    }

    public int decrementGraceLoginsLeft() {
        --this.mGraceLoginsLeft;
        if (this.mGraceLoginsLeft < 0) {
            this.mGraceLoginsLeft = 0;
        }
        return this.mGraceLoginsLeft;
    }

    public void setFailedLogins(int n2) {
        this.mFailedLogins = n2;
    }

    public void setNumberOfFailedLogins(int n2) {
        this.setFailedLogins(n2);
    }

    public void setDeleted(boolean bl2) {
        this.mDeleted = bl2;
    }

    public void incrementFailedLogins() {
        ++this.mFailedLogins;
    }

    public void setAcceptedTerms(boolean bl2) {
        this.mAcceptedTerms = bl2;
    }

    public void setModifyTime(Date date) {
        this.mModifyTime = date;
    }

    public void setModifySource(String string) {
        this.mModifySource = string;
    }

    public void setCreateTime(Date date) {
        this.mCreateTime = date;
    }

    public void setCreateSource(String string) {
        this.mCreateSource = string;
    }

    public void setOrganizations(Collection collection) {
        this.mOrganizations = new HashSet(collection);
    }

    public void addOrganization(String string) {
        this.checkOrganizations();
        this.mOrganizations.add(string);
    }

    public void removeOrganization(String string) {
        this.checkOrganizations();
        this.mOrganizations.remove(string);
    }

    public void initOrganizations() {
        this.mOrganizations = new HashSet();
    }

    public void initPreferences() {
        this.mPreferences = new HashMap();
    }

    public void setPreference(String string, Object object) {
        this.checkPreferences();
        if (object == null) {
            this.mPreferences.remove(string);
        } else {
            this.mPreferences.put(string, object);
        }
    }

    public void setPreferences(Map map) {
        this.checkPreferences();
        this.mPreferences.clear();
        this.mPreferences.putAll(map);
    }

    public void setLocale(Locale locale) {
        String string = null;
        if (locale != null) {
            string = locale.toString();
        }
        this.setPreference("locale", string);
    }

    public void setHomePage(String string) {
        this.setPreference("homepage", string);
    }

    public void setAccountExpiry(Date date) {
        this.mAccountExpiry = date;
    }

    public void setPasswordLifetime(int n2) {
        this.mPasswordLifetime = n2;
    }

    public void initPasswords() {
        this.mPasswords = new ArrayList();
    }

    public void addPassword(Password password) {
        this.checkPasswords();
        this.mPasswords.add(password);
        Collections.sort(this.mPasswords, Password.COMPARATOR);
    }

    public void setPassword(String string) {
        this.checkPasswords();
        Password password = new Password(this.mUsername, string, this.mPasswordLifetime);
        this.addPassword(password);
    }

    public void setCurrentPasswordLifetime(int n2) {
        this.checkPasswords();
        if (this.mPasswords.isEmpty()) {
            return;
        }
        Password password = (Password)this.mPasswords.get(0);
        password.setLifetime(n2);
    }

    public void initPrivileges() {
        this.mUserPrivileges = new HashSet();
        this.mRoles = new HashSet();
    }

    public void addRole(Role role) {
        this.checkPrivileges();
        this.mRoles.add(role);
        Iterator iterator = role.getInherentPrivileges().iterator();
        while (iterator.hasNext()) {
            this.mUserPrivileges.remove(iterator.next());
        }
    }

    public void removeRole(Role role) {
        this.checkPrivileges();
        this.mRoles.remove(role);
    }

    public void setRoles(Collection collection) {
        this.checkPrivileges();
        this.mRoles.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addRole((Role)iterator.next());
        }
    }

    public void addPrivilege(Privilege privilege) {
        this.checkPrivileges();
        if (privilege == null) {
            throw new NullPointerException("null passed to User.addPrivilege()");
        }
        if (this.getRolePrivileges().contains(privilege)) {
            return;
        }
        this.mUserPrivileges.add(privilege);
    }

    public void removePrivilege(Privilege privilege) {
        this.checkPrivileges();
        this.mUserPrivileges.remove(privilege);
    }

    public void resetPrivileges() {
        this.checkPrivileges();
        this.mUserPrivileges.clear();
    }

    public void setPrivileges(Collection collection) {
        this.checkPrivileges();
        this.mUserPrivileges.clear();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addPrivilege((Privilege)iterator.next());
        }
    }

    public void setAccessibleOrders(Collection collection) {
        this.mAccessibleOrders = new HashSet(collection);
    }

    public boolean isBasicUser() {
        return this.mOrganizations == null || this.mUserPrivileges == null || this.mRoles == null || this.mPreferences == null || this.mPasswords == null;
    }

    private void checkOrganizations() {
        if (this.mOrganizations == null) {
            throw new IllegalStateException("user's set of organizations not initialized");
        }
    }

    private void checkPrivileges() {
        if (this.mUserPrivileges == null || this.mRoles == null) {
            throw new IllegalStateException("user privileges and/or roles not loaded yet");
        }
    }

    private void checkPreferences() {
        if (this.mPreferences == null) {
            throw new IllegalStateException("user preferences not loaded yet");
        }
    }

    private void checkAccessibleOrders() {
        if (this.mAccessibleOrders == null) {
            throw new IllegalStateException("set of accessible orders not loaded yet");
        }
    }

    private void checkPasswords() {
        if (this.mPasswords == null) {
            throw new IllegalStateException("list of user's passwords not loaded yet");
        }
    }

    private String getUiStringHelper(String string) {
        if (StringUtils.isBlank((String)string)) {
            return this.mUsername;
        }
        return string + " (" + this.mUsername + ")";
    }

    public String toString() {
        return ToString.object(this, false, this.mUserId + "/" + this.mUsername);
    }

    public String dumpPrivileges() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("username: ").append(this.mUsername).append(" (id ").append(this.mUserId).append(")\n");
        stringBuffer.append("  user privileges = ").append(this.mUserPrivileges).append("\n");
        stringBuffer.append("  user roles = ").append(this.mRoles).append("\n");
        Iterator iterator = this.mRoles.iterator();
        while (iterator.hasNext()) {
            Role role = (Role)iterator.next();
            stringBuffer.append("    role ").append(role).append(" privileges = ").append(role.getInherentPrivileges()).append("\n");
        }
        return stringBuffer.toString();
    }

    public String dumpstr() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.toString() + ":\n");
        stringBuffer.append("  mUserName=" + this.mUsername + "\n");
        stringBuffer.append("  mFirstName=" + this.mFirstName + "\n");
        stringBuffer.append("  mLastName=" + this.mLastName + "\n");
        stringBuffer.append("  mAddress=" + this.mAddress + "\n");
        stringBuffer.append("  mTelephone1=" + this.mTelephone1 + "\n");
        stringBuffer.append("  mTelephone2=" + this.mTelephone2 + "\n");
        stringBuffer.append("  mState=" + (Object)((Object)this.mState) + "\n");
        stringBuffer.append("  inherent privileges:\n");
        Iterator iterator = this.mUserPrivileges.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("    " + iterator.next() + "\n");
        }
        stringBuffer.append("  User roles:\n");
        iterator = this.mRoles.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("    " + iterator.next() + "\n");
        }
        stringBuffer.append("  acquired privileges:\n");
        iterator = this.getAcquiredPrivileges().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("    " + iterator.next() + "\n");
        }
        stringBuffer.append("  all privileges:\n");
        iterator = this.getAllPrivileges().iterator();
        while (iterator.hasNext()) {
            stringBuffer.append("    " + iterator.next() + "\n");
        }
        stringBuffer.append("  mPreferences=" + this.mPreferences + "\n");
        stringBuffer.append("  mAccountExpirationDate=" + this.mAccountExpiry + "\n");
        stringBuffer.append("  mPasswordLifetime=" + this.mPasswordLifetime + "\n");
        stringBuffer.append("  mAddress=" + this.mAddress + "\n");
        stringBuffer.append("  mEmail=" + this.mEmail + "\n");
        return stringBuffer.toString();
    }

    public String getFullName(boolean bl2) {
        String string = "";
        if (!StringCheck.isStringEmpty(this.mFirstName)) {
            string = string + this.mFirstName;
        }
        if (bl2 && !StringCheck.isStringEmpty(this.mMiddleName)) {
            string = string + " " + this.mMiddleName;
        }
        if (!StringCheck.isStringEmpty(this.mLastName)) {
            string = string + " " + this.mLastName;
        }
        return string.trim();
    }

    public String getFullName() {
        return this.getFullName(true);
    }

    public String getSortableFullName(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = StringUtils.trimToEmpty((String)this.mLastName);
        stringBuffer.append(string);
        String string2 = StringUtils.trimToEmpty((String)this.mFirstName);
        if (!StringUtils.isEmpty((String)string2)) {
            if (!StringUtils.isEmpty((String)string)) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string2);
        }
        String string3 = StringUtils.trimToEmpty((String)this.mMiddleName);
        if (bl2 && !StringUtils.isEmpty((String)string3)) {
            if (!StringUtils.isEmpty((String)string2)) {
                stringBuffer.append(" ");
            } else if (!StringUtils.isEmpty((String)string)) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    public String getSortableFullName() {
        return this.getSortableFullName(true);
    }

    public boolean isAccountExpiring() {
        return User.isAccountExpiring(this.mAccountExpiry);
    }

    public static boolean isAccountExpiring(Date date) {
        return User.isAccountExpiring(date, 144);
    }

    public boolean isAccountExpiringVerySoon() {
        return User.isAccountExpiringVerySoon(this.mAccountExpiry);
    }

    public static boolean isAccountExpiringVerySoon(Date date) {
        return User.isAccountExpiring(date, 18);
    }

    private static boolean isAccountExpiring(Date date, int n2) {
        long l2 = User.getAccountExpiryInHours(date);
        return l2 > 0L && l2 < (long)n2;
    }

    public static long getAccountExpiryInHours(Date date) {
        if (date == null) {
            return -1L;
        }
        return (date.getTime() - System.currentTimeMillis()) / 3600000L;
    }

    public static final class NameComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            User user = (User)object;
            User user2 = (User)object2;
            String string = user.getSortableUiString();
            String string2 = user2.getSortableUiString();
            return string.compareTo(string2);
        }
    }

    public static class Preferences {
        public static final String LOCALE = "locale";
        public static final String HOMEPAGE = "homepage";
        public static final String SEARCHFIELD_1 = "search-field-1";
        public static final String SEARCHFIELD_2 = "search-field-2";
        public static final String MENU_MANUAL_STUDY_VALIDATION = "menu-validation";
        public static final String MENU_PACS_STATUS = "menu-status";
        public static final String MENU_PACS_CONFIGURATION = "menu-configuration";
        public static final String MENU_REPORTING = "menu-reporting";
        public static final String MENU_TEACHING_FILE = "menu-teaching-files";
    }

    public static class AccountType
    extends Enum {
        public static AccountType LOCAL = new AccountType("local");
        public static AccountType LDAP = new AccountType("ldap");

        public static AccountType getAccountType(String string) {
            return (AccountType)AccountType.getEnum((Class)(class$DataModels$UserModels$User$AccountType == null ? (class$DataModels$UserModels$User$AccountType = User.class$("DataModels.UserModels.User$AccountType")) : class$DataModels$UserModels$User$AccountType), (String)string);
        }

        private AccountType(String string) {
            super(string);
        }
    }

    public static class State
    extends Enum {
        public static State NORMAL = new State("normal");
        public static State PENDING = new State("pending");
        public static State LOCKED = new State("locked");

        public static State getState(String string) {
            return (State)State.getEnum((Class)(class$DataModels$UserModels$User$State == null ? (class$DataModels$UserModels$User$State = User.class$("DataModels.UserModels.User$State")) : class$DataModels$UserModels$User$State), (String)string);
        }

        private State(String string) {
            super(string);
        }
    }
}

