/*
 * Decompiled with CFR 0.152.
 */
package DataModels.UserModels;

import DataModels.UserModels.Session;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.enums.Enum;
import org.apache.commons.lang.enums.EnumUtils;

public class SessionException
extends Exception {
    public static final FailureType BAD_SESSION_ID;
    public static final FailureType BAD_USERNAME;
    public static final FailureType BAD_PASSWORD;
    public static final FailureType LDAP_CREDENTIALS;
    public static final FailureType LDAP_ERROR;
    public static final FailureType ACCOUNT_DELETED;
    public static final FailureType ACCOUNT_EXPIRED;
    public static final FailureType SESSION_EXPIRED;
    public static final FailureType USER_MISMATCH;
    public static final FailureType NEW_USER;
    public static final FailureType MAX_FAILURES;
    public static final FailureType LOCKED_USER;
    public static final FailureType PASSWORD_EXPIRED;
    public static final FailureType BAD_HOST;
    public static final FailureType OTHER;
    private static final FailureType[] LOGIN_FAILURES;
    private FailureType mFailureType;
    private Session mSession;
    private String mSessionId;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static FailureType getFailureType(String string) {
        return (FailureType)EnumUtils.getEnum((Class)FailureType.class, (String)string);
    }

    public SessionException(FailureType failureType, Session session, String string, String string2) {
        super(string2);
        if (!$assertionsDisabled && session != null && !session.getSessionId().equals(string)) {
            throw new AssertionError((Object)"Invalid usage of SessionException session.getSessionId() and sessionId don't match");
        }
        this.mFailureType = failureType;
        this.mSession = session;
        this.mSessionId = string;
    }

    public SessionException(FailureType failureType, Session session, String string) {
        this(failureType, session, string, null);
    }

    public SessionException(FailureType failureType, String string) {
        this(failureType, null, string, null);
    }

    public SessionException(FailureType failureType) {
        this(failureType, null, null, null);
    }

    public String getMessage() {
        String string = super.getMessage();
        if (string == null) {
            return this.mFailureType.getDescription();
        }
        return (Object)((Object)this.mFailureType) + ": " + string;
    }

    public boolean isLoginFailure() {
        return ArrayUtils.contains((Object[])LOGIN_FAILURES, (Object)((Object)this.mFailureType));
    }

    public FailureType getFailureType() {
        return this.mFailureType;
    }

    public Session getSession() {
        return this.mSession;
    }

    public String getSessionId() {
        return this.mSessionId;
    }

    static {
        $assertionsDisabled = !SessionException.class.desiredAssertionStatus();
        BAD_SESSION_ID = new FailureType("bad_session_id", "Bad session ID");
        BAD_USERNAME = new FailureType("bad_username", "Bad username");
        BAD_PASSWORD = new FailureType("bad_password", "Bad password");
        LDAP_CREDENTIALS = new FailureType("ldap_credentials", "LDAP credentials rejected (bad username or password)");
        LDAP_ERROR = new FailureType("ldap_error", "Error connecting to LDAP server");
        ACCOUNT_DELETED = new FailureType("account_deleted", "Account deleted");
        ACCOUNT_EXPIRED = new FailureType("account_expired", "Expired user account");
        SESSION_EXPIRED = new FailureType("session_expired", "Session expired");
        USER_MISMATCH = new FailureType("username_mismatch", "Username/session mismatch");
        NEW_USER = new FailureType("new_account", "New user account");
        MAX_FAILURES = new FailureType("max_failures", "Too many failed login attempts");
        LOCKED_USER = new FailureType("locked_account", "Locked user account");
        PASSWORD_EXPIRED = new FailureType("password_expired", "Password expired");
        BAD_HOST = new FailureType("bad_host", "Invalid client host");
        OTHER = new FailureType("other", "Unknown failure");
        LOGIN_FAILURES = new FailureType[]{BAD_USERNAME, BAD_PASSWORD, LDAP_CREDENTIALS, LDAP_ERROR, ACCOUNT_DELETED, NEW_USER, MAX_FAILURES, LOCKED_USER, ACCOUNT_EXPIRED};
    }

    public static class FailureType
    extends Enum {
        private String mDescription;

        private FailureType(String string, String string2) {
            super(string);
            this.mDescription = string2;
        }

        public String toString() {
            return this.getName();
        }

        public String getDescription() {
            return this.mDescription;
        }
    }
}

