/*
 * Decompiled with CFR 0.152.
 */
package DataModels.UserModels;

import DataModels.UserModels.ModificationTracked;
import DataModels.UserModels.Privilege;
import DataModels.UserModels.Privileged;
import StringUtilities.ToString;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Role
implements Privileged,
ModificationTracked {
    public static final int NEW_ROLE_ID = -1;
    public static final int IMS_ROLE_ID = 0;
    public static final int ADMIN_ROLE_ID = 1;
    private int mRoleId = -1;
    private String mRoleName;
    private boolean mDeleted;
    private Date mCreateTime;
    private String mCreateSource;
    private Date mModifyTime;
    private String mModifySource;
    private Set mPrivileges;

    public Role(int n2, String string, List list) {
        this.mRoleId = n2;
        this.setRoleName(string);
        this.mPrivileges = new HashSet(list);
    }

    public Role(int n2, String string) {
        this(n2, string, Collections.EMPTY_LIST);
    }

    public Role(String string) {
        this(-1, string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Role)) {
            return false;
        }
        Role role = (Role)object;
        return this.mRoleId == role.mRoleId && this.mRoleName.equals(role.mRoleName);
    }

    public int hashCode() {
        return this.mRoleName.hashCode() | this.mRoleId;
    }

    public String toString() {
        return ToString.object(this, false, this.mRoleId + "/" + this.mRoleName);
    }

    public int getRoleId() {
        return this.mRoleId;
    }

    public int getId() {
        return this.mRoleId;
    }

    public String getRoleName() {
        return this.mRoleName;
    }

    public boolean isDeleted() {
        return this.mDeleted;
    }

    public Date getCreateTime() {
        return this.mCreateTime;
    }

    public String getCreateSource() {
        return this.mCreateSource;
    }

    public Date getModifyTime() {
        return this.mModifyTime;
    }

    public String getModifySource() {
        return this.mModifySource;
    }

    public boolean isReserved() {
        return this.mRoleId == 0 || this.mRoleId == 1;
    }

    public boolean hasPrivilege(Privilege privilege) {
        return this.mPrivileges.contains(privilege);
    }

    public Set getInherentPrivileges() {
        return Collections.unmodifiableSet(this.mPrivileges);
    }

    public Set getAcquiredPrivileges() {
        return Collections.EMPTY_SET;
    }

    public void setRoleId(int n2) {
        if (this.mRoleId != -1) {
            throw new IllegalStateException("role ID already set (to " + this.mRoleId + ")");
        }
        this.mRoleId = n2;
    }

    public void setRoleName(String string) {
        if (string != null) {
            string = string.trim();
        }
        this.mRoleName = string;
    }

    public void setDeleted(boolean bl2) {
        this.mDeleted = bl2;
    }

    public void setCreateTime(Date date) {
        this.mCreateTime = date;
    }

    public void setCreateSource(String string) {
        this.mCreateSource = string;
    }

    public void setModifyTime(Date date) {
        this.mModifyTime = date;
    }

    public void setModifySource(String string) {
        this.mModifySource = string;
    }

    public void resetPrivileges() {
        this.mPrivileges.clear();
    }

    public void addPrivilege(Privilege privilege) {
        if (privilege == null) {
            throw new NullPointerException("null passed to Role.addPrivilege()");
        }
        this.mPrivileges.add(privilege);
    }

    public void removePrivilege(Privilege privilege) {
        this.mPrivileges.remove(privilege);
    }

    public void setPrivileges(Collection collection) {
        this.mPrivileges = new HashSet(collection);
    }

    public static class RoleComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            Role role = (Role)object;
            Role role2 = (Role)object2;
            if (0 == role.getId()) {
                return 1;
            }
            if (0 == role2.getId()) {
                return -1;
            }
            return role.getRoleName().compareToIgnoreCase(role2.getRoleName());
        }
    }
}

