/*
 * Decompiled with CFR 0.152.
 */
package DataModels.UserModels;

import DataModels.UserModels.Privilege;
import DataModels.UserModels.PrivilegeCategory;
import RuntimeTool.ControlFile;
import RuntimeTool.ControlFileException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class PrivilegeSet {
    private static List mDefaultCategories = new ArrayList();
    public static final Privilege SEARCH_BY_PATIENT_NAME = Categories.GLOBAL.add("search_by_patient_name", 4);
    public static final Privilege VIEW_PATIENT_NAME = Categories.GLOBAL.add("view_patient_name", 8);
    public static final Privilege MULTIPLE_SESSIONS = Categories.GLOBAL.add("multiple_sessions");
    public static final Privilege EXTERNAL_ACCESS = Categories.GLOBAL.add("external_access");
    public static final Privilege VIEW_IMAGE = Categories.IMAGE.add("view_image", 1);
    public static final Privilege MOVE_IMAGE = Categories.IMAGE.add("move_image", 4);
    public static final Privilege FIX_PATIENT_INFO = Categories.IMAGE.add("fix_patient_info", 16);
    public static final Privilege DELETE_PATIENT_INFO = Categories.IMAGE.add("delete_patient_info", 32);
    public static final Privilege VIEW_TF = Categories.IMAGE.add("view_tf", 64);
    public static final Privilege CREATE_TF = Categories.IMAGE.add("create_tf", 128);
    public static final Privilege SEND_TO_PACS = Categories.IMAGE.add("send_to_pacs");
    public static final Privilege MOVE_TO_RESTRICTED_AE = Categories.IMAGE.add("move_to_restricted_ae");
    public static final Privilege MOVE_TO_ANY_AE = Categories.IMAGE.add("move_to_any_ae");
    public static final Privilege STUDY_ASSIGNER = Categories.IMAGE.add("study_assigner");
    public static final Privilege VIEW_REPORT = Categories.REPORT.add("view_report", 2);
    public static final Privilege MODIFY_REPORT = Categories.REPORT.add("modify_report", 4);
    public static final Privilege MODIFY_FINAL_REPORT = Categories.REPORT.add("modify_final_report", 8);
    public static final Privilege VIEW_ER_REPORTS = Categories.REPORT.add("view_er_reports", 16);
    public static final Privilege CREATE_ER_REPORTS = Categories.REPORT.add("create_er_reports", 32);
    public static final Privilege VALIDATE_STUDY = Categories.REPORT.add("validate_study", 64);
    public static final Privilege VALIDATE_OVERRIDE = Categories.REPORT.add("validate_override", 128);
    public static final Privilege VIEW_EIT_IMPRESSIONS = Categories.REPORT.add("view_eit_impressions", 256);
    public static final Privilege MODIFY_EIT_IMPRESSIONS = Categories.REPORT.add("modify_eit_impressions", 512);
    public static final Privilege TRANSCRIBE_REPORT = Categories.REPORT.add("transcribe_report", 1024);
    public static final Privilege DICTATE_REPORT = Categories.REPORT.add("dictate_report", 2048);
    public static final Privilege CREATE_ORDER = Categories.REPORT.add("create_order", 4096);
    public static final Privilege MODIFY_ORDER_STATUS = Categories.REPORT.add("modify_order_status");
    public static final Privilege REMOVE_FROM_VALIDATION = Categories.REPORT.add("remove_from_validation");
    public static final Privilege MANAGE_WORKLISTS = Categories.REPORT.add("manage_worklists");
    public static final Privilege RESERVE_WORKLIST_ITEM = Categories.REPORT.add("reserve_worklist_item");
    public static final Privilege MANAGE_IPMON = Categories.ADMIN.add("manage_ipmon");
    public static final Privilege VIEW_STATISTICS = Categories.ADMIN.add("view_statistics");
    public static final Privilege MANAGE_QUEUES = Categories.ADMIN.add("manage_queues");
    public static final Privilege VIEW_TRANSFER_REPORTS = Categories.ADMIN.add("view_transfer_reports");
    public static final Privilege MANAGE_MODALITY_WORKLISTS = Categories.ADMIN.add("manage_modality_worklists");
    public static final Privilege MANAGE_REPORTS = Categories.ADMIN.add("manage_reports");
    public static final Privilege MANAGE_REPORT_TEMPLATES = Categories.ADMIN.add("manage_report_templates");
    public static final Privilege MANAGE_DICOM_ENTITIES = Categories.ADMIN.add("manage_dicom_entities");
    public static final Privilege MANAGE_AUTOROUTING = Categories.ADMIN.add("manage_autorouting");
    public static final Privilege MANAGE_DICOM_PREFETCH = Categories.ADMIN.add("manage_dicom_prefetch");
    public static final Privilege MANAGE_RIS_PREFETCH = Categories.ADMIN.add("manage_ris_prefetch");
    public static final Privilege MANAGE_JPEG_PRESETS = Categories.ADMIN.add("manage_jpeg_presets");
    public static final Privilege MANAGE_USERS = Categories.ADMIN.add("manage_users");
    public static final Privilege AUDIT_USERS = Categories.ADMIN.add("audit_users");
    public static final Privilege CUSTOMIZE_USER_FORMS = Categories.ADMIN.add("customize_user_forms");
    public static final Privilege GRANT_STUDY_ACCESS = Categories.PRIVACY.add("grant_study_access");
    public static final Privilege THUMBNAILS = Categories.INTELEVIEWER_FEATURES.add("thumbnails");
    public static final Privilege ADVANCED_LAYOUT_MGMT = Categories.INTELEVIEWER_FEATURES.add("advanced_layout_mgmt");
    public static final Privilege BASIC_3D = Categories.INTELEVIEWER_FEATURES.add("basic_3d");
    public static final Privilege THIRD_PARTY_VIEWER = Categories.INTELEVIEWER_FEATURES.add("third_party_viewer");
    public static final Privilege THIRD_PARTY_RIS = Categories.INTELEVIEWER_FEATURES.add("third_party_ris");
    public static final Privilege ANNOTATIONS = Categories.INTELEVIEWER_FEATURES.add("annotations");
    public static final Privilege KEY_IMAGES = Categories.INTELEVIEWER_FEATURES.add("key_images");
    public static final Privilege STUDY_VIEWED_STATUS = Categories.INTELEVIEWER_FEATURES.add("study_viewed_status");
    public static final Privilege VIEW_TEACHING_FILES = Categories.INTELEVIEWER_FEATURES.add("view_teaching_files");
    public static final Privilege EDIT_TEACHING_FILES = Categories.INTELEVIEWER_FEATURES.add("edit_teaching_files");
    public static final Privilege EXPORT_DICOM = Categories.INTELEVIEWER_FEATURES.add("export_dicom");
    public static final Privilege LONG_TERM_DISK_CACHING = Categories.INTELEVIEWER_FEATURES.add("long_term_disk_caching");
    public static final Privilege AUTOMATIC_LOGIN = Categories.INTELEVIEWER_FEATURES.add("automatic_login");
    public static final Privilege DICOM_PRINT = Categories.INTELEVIEWER_FEATURES.add("dicom_print");
    public static final Privilege DICOM_SITE_LICENSE = Categories.INTELEVIEWER_FEATURES.add("dicom_site_license");
    public static final Privilege SAVE_PRESENTATION_STATE = Categories.INTELEVIEWER_FEATURES.add("save_presentation_state");
    public static final Privilege MANAGE_PROFILE_TEMPLATES = Categories.INTELEVIEWER_FEATURES.add("manage_profile_templates");
    public static final Object DISABLE_SEARCH_TOOL = Categories.RESTRICTIONS.add("disable_search_tool");
    public static final Privilege STUDY_ACCESS_RESTRICTIONS = Categories.RESTRICTIONS.add("study_access_restrictions");
    public static final Privilege UNKNOWN = new Privilege("XXX_unknown", Categories.GLOBAL, -1);
    private static final String STANDARD_PRIVILEGE_FILE = "/usr/local/tools/control_files/privileges/UserPrivileges.cfg";
    private static PrivilegeSet mBuiltinInstance = new PrivilegeSet(mDefaultCategories);
    private static PrivilegeSet mDefaultInstance;
    static final String CONTROL_FILE_CATEGORY_PREFIX = "CATEGORY-";
    private Map mCategories = Collections.synchronizedMap(new LinkedHashMap());
    private Map mPrivileges = Collections.synchronizedMap(new HashMap());

    private static PrivilegeCategory addCategory(String string) {
        PrivilegeCategory privilegeCategory = new PrivilegeCategory(string);
        mDefaultCategories.add(privilegeCategory);
        return privilegeCategory;
    }

    private PrivilegeSet(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            PrivilegeCategory privilegeCategory = (PrivilegeCategory)iterator.next();
            this.mCategories.put(privilegeCategory.getName(), privilegeCategory);
            Iterator iterator2 = privilegeCategory.iterator();
            while (iterator2.hasNext()) {
                Privilege privilege = (Privilege)iterator2.next();
                this.mPrivileges.put(privilege.getName(), privilege);
            }
        }
        this.mPrivileges.put("third_party_3d_viewer", THIRD_PARTY_VIEWER);
    }

    static PrivilegeSet getBuiltinInstance() {
        return mBuiltinInstance;
    }

    static PrivilegeSet getInstance(String string) throws ControlFileException {
        ControlFile controlFile = new ControlFile(string);
        controlFile.Read();
        Vector vector = controlFile.GetSectionsStartingWith(CONTROL_FILE_CATEGORY_PREFIX);
        ArrayList<PrivilegeCategory> arrayList = new ArrayList<PrivilegeCategory>(vector.size());
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = string2.substring(CONTROL_FILE_CATEGORY_PREFIX.length());
            PrivilegeCategory privilegeCategory = new PrivilegeCategory(string3);
            Map map = controlFile.GetSectionOrdered(string2);
            Iterator iterator2 = map.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                String string4 = (String)entry.getKey();
                int n2 = Integer.decode((String)entry.getValue());
                privilegeCategory.add(string4, n2);
            }
            arrayList.add(privilegeCategory);
        }
        return new PrivilegeSet(arrayList);
    }

    public static synchronized PrivilegeSet getInstance() {
        if (mDefaultInstance == null) {
            if (!new File(STANDARD_PRIVILEGE_FILE).exists()) {
                mDefaultInstance = mBuiltinInstance;
                return mBuiltinInstance;
            }
            try {
                mDefaultInstance = PrivilegeSet.getInstance(STANDARD_PRIVILEGE_FILE);
            }
            catch (ControlFileException controlFileException) {
                throw new RuntimeException(controlFileException);
            }
        }
        return mDefaultInstance;
    }

    public Collection getAll() {
        return this.mPrivileges.values();
    }

    public Iterator iterator() {
        return this.mPrivileges.values().iterator();
    }

    PrivilegeCategory getCategory(String string) {
        return (PrivilegeCategory)this.mCategories.get(string);
    }

    private PrivilegeCategory getGlobalCategory() {
        return (PrivilegeCategory)this.mCategories.get("global");
    }

    private PrivilegeCategory getImageCategory() {
        return (PrivilegeCategory)this.mCategories.get("image");
    }

    private PrivilegeCategory getReportCategory() {
        return (PrivilegeCategory)this.mCategories.get("report");
    }

    public PrivilegeCategory getInteleViewerFeatures() {
        return (PrivilegeCategory)this.mCategories.get("inteleviewer_features");
    }

    public PrivilegeCategory getRestrictionsCategory() {
        return (PrivilegeCategory)this.mCategories.get("restrictions");
    }

    public List getAllCategories() {
        return new ArrayList(this.mCategories.values());
    }

    public List getPrivilegeCategories() {
        List list = this.getAllCategories();
        list.remove(this.getRestrictionsCategory());
        return list;
    }

    public Privilege getPrivilege(String string) {
        return (Privilege)this.mPrivileges.get(string);
    }

    private int getPrivilegeBitmap(PrivilegeCategory privilegeCategory, Collection collection) {
        int n2 = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Privilege privilege = (Privilege)iterator.next();
            if (!privilege.isOldPrivilege() || !privilege.getCategory().nameEquals(privilegeCategory)) continue;
            n2 |= privilege.getMask();
        }
        return n2;
    }

    int getGlobalPrivilegeBitmap(Collection collection) {
        return this.getPrivilegeBitmap(this.getGlobalCategory(), collection);
    }

    int getImagePrivilegeBitmap(Collection collection) {
        return this.getPrivilegeBitmap(this.getImageCategory(), collection);
    }

    int getReportPrivilegeBitmap(Collection collection) {
        return this.getPrivilegeBitmap(this.getReportCategory(), collection);
    }

    public static List getPrivilegeNames(Collection collection) {
        ArrayList<String> arrayList = new ArrayList<String>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            arrayList.add(((Privilege)iterator.next()).getName());
        }
        return arrayList;
    }

    static /* synthetic */ PrivilegeCategory access$000(String string) {
        return PrivilegeSet.addCategory(string);
    }

    static class Categories {
        static final PrivilegeCategory GLOBAL = PrivilegeSet.access$000("global");
        static final PrivilegeCategory IMAGE = PrivilegeSet.access$000("image");
        static final PrivilegeCategory REPORT = PrivilegeSet.access$000("report");
        static final PrivilegeCategory PRIVACY = PrivilegeSet.access$000("privacy");
        static final PrivilegeCategory ADMIN = PrivilegeSet.access$000("admin");
        static final PrivilegeCategory INTELEVIEWER_FEATURES = PrivilegeSet.access$000("inteleviewer_features");
        static final PrivilegeCategory RESTRICTIONS = PrivilegeSet.access$000("restrictions");

        Categories() {
        }
    }

    public static class CategoryNames {
        public static final String GLOBAL = "global";
        public static final String IMAGE = "image";
        public static final String REPORT = "report";
        public static final String PRIVACY = "privacy";
        public static final String ADMIN = "admin";
        public static final String INTELEVIEWER_FEATURES = "inteleviewer_features";
        public static final String RESTRICTIONS = "restrictions";
    }
}

