/*
 * Decompiled with CFR 0.152.
 */
package DataModels.SearchFramework;

import DataModels.SearchFramework.Clause;
import DataModels.SearchFramework.OperandLookup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Match {
    private final List mClauseList = new ArrayList();

    public Match() {
    }

    public Match(Match match) {
        Iterator iterator = match.clauseIterator();
        while (iterator.hasNext()) {
            this.addClause((Clause)iterator.next());
        }
    }

    public Match(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.addClause((Clause)iterator.next());
        }
    }

    public Match(Clause clause) {
        this.addClause(clause);
    }

    public void addClause(Clause clause) {
        this.mClauseList.add(new Clause(clause));
    }

    public Iterator clauseIterator() {
        return this.mClauseList.iterator();
    }

    public int getNumberOfClauses() {
        return this.mClauseList.size();
    }

    public Clause getClause(int n2) {
        return (Clause)this.mClauseList.get(n2);
    }

    public List getClauseList() {
        return Collections.unmodifiableList(this.mClauseList);
    }

    public void setClauseList(List list) {
        this.mClauseList.clear();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Clause clause = (Clause)iterator.next();
            this.addClause(clause);
        }
    }

    public void setClauseList(Clause clause) {
        this.mClauseList.clear();
        this.addClause(clause);
    }

    public boolean isSatisfied(OperandLookup operandLookup) {
        Iterator iterator = this.clauseIterator();
        while (iterator.hasNext()) {
            Clause clause = (Clause)iterator.next();
            if (!clause.isSatisfied(operandLookup)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(" clauses:\n");
        Iterator iterator = this.mClauseList.iterator();
        while (iterator.hasNext()) {
            Clause clause = (Clause)iterator.next();
            stringBuffer.append(clause.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

