/*
 * Decompiled with CFR 0.152.
 */
package DataModels.PatientModels;

import DataModels.AbstractDataModel;
import DataModels.ModelProperty;
import DateUtilities.DateExtractor;
import RuntimeTool.DebugManager;
import StringUtilities.StringCheck;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Series
extends AbstractDataModel {
    public static final String TEACHING_CASE_PR_SERIES_DESCRIPTION = "TeachingCase Images";
    private String mBodyPartExamined = null;
    private String mModality = null;
    private int mNumberOfImages;
    private Date mSeriesDateTime = null;
    private String mSeriesDescription = null;
    private String mSeriesInstanceUid = null;
    private String mSeriesNumber = null;
    private String mViewPosition = null;
    private String mStudyInstanceUid = null;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$Date;

    public Collection getProperties() {
        return Property.getAllProperties();
    }

    public String getBodyPartExamined() {
        return this.mBodyPartExamined;
    }

    public void setBodyPartExamined(String string) {
        this.mBodyPartExamined = string;
    }

    public String getModality() {
        return this.mModality;
    }

    public void setModality(String string) {
        this.mModality = string;
    }

    public int getNumberOfImages() {
        return this.mNumberOfImages;
    }

    public void setNumberOfImages(int n2) {
        this.mNumberOfImages = n2;
    }

    public Date getSeriesDateTime() {
        return this.mSeriesDateTime;
    }

    public void setSeriesDateTime(String string, String string2) {
        if (StringCheck.isStringBlank(string) || StringCheck.isStringBlank(string2)) {
            this.mSeriesDateTime = null;
            return;
        }
        try {
            DateExtractor dateExtractor = new DateExtractor();
            dateExtractor.setDateToParse(string + string2);
            this.setSeriesDateTime(dateExtractor.getCalendar());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setSeriesDateTime(DateExtractor.getInvalidDate());
            DebugManager.getDefault().printException("IllegalArgumentException while trying to parse series date/time [" + string + string2 + "]. Setting seriesDateTime to invalid value " + this.getSeriesDateTime().toString() + " so we can catch it later", illegalArgumentException);
        }
    }

    public void setSeriesDateTime(DateFormat dateFormat, String string) {
        try {
            this.setSeriesDateTime(dateFormat.parse(string));
        }
        catch (ParseException parseException) {
            this.setSeriesDateTime(DateExtractor.getInvalidDate());
            DebugManager.getDefault().printException("Cannot parse date " + string, parseException);
        }
    }

    public void setSeriesDateTime(Date date) {
        this.mSeriesDateTime = date;
    }

    public void setSeriesDateTime(Calendar calendar) {
        this.setSeriesDateTime(calendar.getTime());
    }

    public String getSeriesDescription() {
        return this.mSeriesDescription;
    }

    public void setSeriesDescription(String string) {
        this.mSeriesDescription = string;
    }

    public String getSeriesInstanceUid() {
        return this.mSeriesInstanceUid;
    }

    public void setSeriesInstanceUid(String string) {
        this.mSeriesInstanceUid = string;
    }

    public String getSeriesNumber() {
        return this.mSeriesNumber;
    }

    public void setSeriesNumber(String string) {
        this.mSeriesNumber = string;
    }

    public String getSeriesId() {
        return this.getSeriesNumber();
    }

    public void setSeriesId(String string) {
        this.setSeriesNumber(string);
    }

    public String getViewPosition() {
        return this.mViewPosition;
    }

    public void setViewPosition(String string) {
        this.mViewPosition = string;
    }

    public String getStudyInstanceUid() {
        return this.mStudyInstanceUid;
    }

    public void setStudyInstanceUid(String string) {
        this.mStudyInstanceUid = string;
    }

    public static Set getUidList(Collection collection) {
        HashSet<String> hashSet = new HashSet<String>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Series series = (Series)iterator.next();
            hashSet.add(series.getSeriesInstanceUid());
        }
        return hashSet;
    }

    public boolean isTeachingCasePrSeries() {
        return TEACHING_CASE_PR_SERIES_DESCRIPTION.equalsIgnoreCase(this.mSeriesDescription) && "PR".equalsIgnoreCase(this.mModality);
    }

    public static class Property
    extends ModelProperty {
        private static Map mNameMap = new HashMap();
        public static final Property BodyPartExamined = new Property(class$java$lang$String == null ? (class$java$lang$String = Series.class$("java.lang.String")) : class$java$lang$String, "BodyPartExamined", "Body Part Examined");
        public static final Property Modality = new Property(class$java$lang$String == null ? (class$java$lang$String = Series.class$("java.lang.String")) : class$java$lang$String, "Modality", "Modality");
        public static final Property NumberOfImages = new Property(class$java$lang$Integer == null ? (class$java$lang$Integer = Series.class$("java.lang.Integer")) : class$java$lang$Integer, "NumberOfImages", "Number Of Images");
        public static final Property SeriesDateTime = new Property(class$java$util$Date == null ? (class$java$util$Date = Series.class$("java.util.Date")) : class$java$util$Date, "SeriesDateTime", "Date and Time");
        public static final Property SeriesDescription = new Property(class$java$lang$String == null ? (class$java$lang$String = Series.class$("java.lang.String")) : class$java$lang$String, "SeriesDescription", "Description");
        public static final Property SeriesInstanceUid = new Property(class$java$lang$String == null ? (class$java$lang$String = Series.class$("java.lang.String")) : class$java$lang$String, "SeriesInstanceUid", "Series UID");
        public static final Property SeriesNumber = new Property(class$java$lang$String == null ? (class$java$lang$String = Series.class$("java.lang.String")) : class$java$lang$String, "SeriesNumber", "Number");
        public static final Property ViewPosition = new Property(class$java$lang$String == null ? (class$java$lang$String = Series.class$("java.lang.String")) : class$java$lang$String, "ViewPosition", "View Position");
        public static final Property StudyInstanceUid = new Property(class$java$lang$String == null ? (class$java$lang$String = Series.class$("java.lang.String")) : class$java$lang$String, "StudyInstanceUid", "Study UID");

        protected Property(Class clazz, String string, String string2) {
            super(clazz, string, string2);
            mNameMap.put(string, this);
        }

        public static Property getInstance(String string) {
            return (Property)mNameMap.get(string);
        }

        public static Collection getAllProperties() {
            return Collections.unmodifiableCollection(mNameMap.values());
        }

        public static Property[] getAllPropertiesAsArray() {
            return mNameMap.values().toArray(new Property[mNameMap.size()]);
        }
    }
}

