/*
 * Decompiled with CFR 0.152.
 */
package DataModels;

import DataModels.ModelProperty;
import DataModels.ObservableDataModel;
import java.util.HashMap;
import java.util.Map;

public abstract class MapDataModel
extends ObservableDataModel {
    private Map mValues = new HashMap();

    public void setProperty(ModelProperty modelProperty, Object object) throws IllegalArgumentException {
        ObservableDataModel.validateProperty(this, modelProperty);
        this.validateType(modelProperty, object);
        Object object2 = this.getProperty(modelProperty);
        this.mValues.put(modelProperty, object);
        this.firePropertyChange(modelProperty, object2);
    }

    public Object getProperty(ModelProperty modelProperty) throws IllegalArgumentException {
        ObservableDataModel.validateProperty(this, modelProperty);
        return this.mValues.get(modelProperty);
    }

    protected boolean hasPropertyValue(ModelProperty modelProperty) {
        return this.mValues.containsKey(modelProperty);
    }

    private void validateType(ModelProperty modelProperty, Object object) {
        Class<?> clazz;
        if (object == null) {
            return;
        }
        Class clazz2 = modelProperty.getValueClass();
        if (!clazz2.isAssignableFrom(clazz = object.getClass())) {
            throw new IllegalArgumentException("Property type: " + clazz2 + " is not compatible with type: " + clazz);
        }
    }

    public void setProperty(ModelProperty modelProperty, int n2) {
        this.setProperty(modelProperty, new Integer(n2));
    }

    public int getIntProperty(ModelProperty modelProperty) {
        ObservableDataModel.validateProperty(this, modelProperty);
        return (Integer)this.getProperty(modelProperty);
    }

    public int hashCode() {
        return ((Object)this.mValues).hashCode() ^ ((Object)this.mPropertyMap).hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MapDataModel)) {
            return false;
        }
        MapDataModel mapDataModel = (MapDataModel)object;
        return ((Object)mapDataModel.mValues).equals(this.mValues) && ((Object)mapDataModel.mPropertyMap).equals(this.mPropertyMap);
    }
}

