/*
 * Decompiled with CFR 0.152.
 */
package DataModels;

import DataModels.DataModel;
import DataModels.ModelProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Transformer;

public class DataModelBuilder {
    public static boolean equals(DataModel dataModel, DataModel dataModel2, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModelProperty modelProperty = (ModelProperty)iterator.next();
            Object object = dataModel.getProperty(modelProperty);
            Object object2 = dataModel2.getProperty(modelProperty);
            boolean bl2 = object == null ? object2 == null : object.equals(object2);
            if (bl2) continue;
            return false;
        }
        return true;
    }

    public static void copyValues(DataModel dataModel, DataModel dataModel2, Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModelProperty modelProperty = (ModelProperty)iterator.next();
            dataModel.setProperty(modelProperty, dataModel2.getProperty(modelProperty));
        }
    }

    public static void copyValues(DataModel dataModel, DataModel dataModel2) {
        DataModelBuilder.copyValues(dataModel, dataModel2, dataModel2.getProperties());
    }

    public static Object convertValue(ModelProperty modelProperty, Object object) {
        if (object == null) {
            return null;
        }
        Class clazz = modelProperty.getValueClass();
        if (clazz.isAssignableFrom(object.getClass())) {
            return object;
        }
        if (clazz == String.class) {
            return object.toString();
        }
        if (clazz == Integer.class) {
            return DataModelBuilder.convertToInteger(object);
        }
        return object;
    }

    private static Object convertToInteger(Object object) {
        try {
            return new Integer(Integer.parseInt(object.toString()));
        }
        catch (NumberFormatException numberFormatException) {
            return object;
        }
    }

    public static int hashCode(DataModel dataModel, Collection collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModelProperty modelProperty = (ModelProperty)iterator.next();
            arrayList.add(dataModel.getProperty(modelProperty));
        }
        return ((Object)arrayList).hashCode();
    }

    public static Map convertToMap(DataModel dataModel, Collection collection) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModelProperty modelProperty = (ModelProperty)iterator.next();
            hashMap.put(modelProperty.getName(), dataModel.getProperty(modelProperty));
        }
        return hashMap;
    }

    public static void setProperties(DataModel dataModel, Collection collection, Map map) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ModelProperty modelProperty = (ModelProperty)iterator.next();
            dataModel.setProperty(modelProperty, map.get(modelProperty.getName()));
        }
    }

    public static class GetPropertyTransformer
    implements Transformer {
        private final ModelProperty mProperty;

        public GetPropertyTransformer(ModelProperty modelProperty) {
            this.mProperty = modelProperty;
        }

        public Object transform(Object object) {
            return ((DataModel)object).getProperty(this.mProperty);
        }
    }
}

