/*
 * Decompiled with CFR 0.152.
 */
package Auditing;

import Auditing.RemoteAuditWorker;
import DataStructures.WorkQueue;
import Notification.Notifier;
import RuntimeTool.DebugManager;
import com.intelerad.datamodels.audit.AuditAction;
import java.net.MalformedURLException;
import java.net.URL;

public class RemoteAuditSender
extends Thread {
    private static final int MAXIMUM_QUEUED_MESSAGES = 1000;
    private WorkQueue mAuditRequests;

    private RemoteAuditSender(WorkQueue workQueue) {
        this.mAuditRequests = workQueue;
    }

    public static RemoteAuditSender createRemoteAuditSender(URL uRL, Notifier notifier) {
        WorkQueue workQueue = new WorkQueue(1000);
        RemoteAuditWorker remoteAuditWorker = new RemoteAuditWorker(uRL, workQueue, notifier);
        remoteAuditWorker.start();
        return new RemoteAuditSender(workQueue);
    }

    public void close() {
        this.mAuditRequests.close();
    }

    public void sendByUsernameAndSeries(String string, String string2, AuditAction auditAction) {
        AuditMessage auditMessage = AuditMessage.createByUserAndSeries();
        auditMessage.initAuditMessage(string, string2, auditAction);
        this.sendMessage(auditMessage);
    }

    public void sendByAeTitleAndSeries(String string, String string2, AuditAction auditAction) {
        AuditMessage auditMessage = AuditMessage.createByAeTitleAndSeries();
        auditMessage.initAuditMessage(string, string2, auditAction);
        this.sendMessage(auditMessage);
    }

    public void sendByUsernameAndStudy(String string, String string2, AuditAction auditAction) {
        AuditMessage auditMessage = AuditMessage.createByUserAndStudy();
        auditMessage.initAuditMessage(string, string2, auditAction);
        this.sendMessage(auditMessage);
    }

    public void sendByAeTitleAndStudy(String string, String string2, AuditAction auditAction) {
        AuditMessage auditMessage = AuditMessage.createByAeTitleAndStudy();
        auditMessage.initAuditMessage(string, string2, auditAction);
        this.sendMessage(auditMessage);
    }

    public void sendByUsernameAndPatient(String string, String string2, AuditAction auditAction) {
        AuditMessage auditMessage = AuditMessage.createByUserAndPatient();
        auditMessage.initAuditMessage(string, string2, auditAction);
        this.sendMessage(auditMessage);
    }

    public void sendByAeTitleAndPatient(String string, String string2, AuditAction auditAction) {
        AuditMessage auditMessage = AuditMessage.createByAeTitleAndPatient();
        auditMessage.initAuditMessage(string, string2, auditAction);
        this.sendMessage(auditMessage);
    }

    public void sendByUsernameAndAccession(String string, String string2, AuditAction auditAction) {
        AuditMessage auditMessage = AuditMessage.createByUserAndAccession();
        auditMessage.initAuditMessage(string, string2, auditAction);
        this.sendMessage(auditMessage);
    }

    public void sendByAeTitleAndAccession(String string, String string2, AuditAction auditAction) {
        AuditMessage auditMessage = AuditMessage.createByAeTitleAndAccession();
        auditMessage.initAuditMessage(string, string2, auditAction);
        this.sendMessage(auditMessage);
    }

    private void sendMessage(AuditMessage auditMessage) {
        if (!this.mAuditRequests.addWork(auditMessage)) {
            String string = "Audit request queue full (1000 entries) - dropping " + auditMessage;
            DebugManager.getDefault().printError(string);
            return;
        }
    }

    public static void main(String[] stringArray) throws MalformedURLException {
        Notifier notifier = Notifier.getInstance("Auditing.Audit", "PACS-3-4-1-P107", "AUDITING-VER-4-1-6-P1-B5");
        RemoteAuditSender remoteAuditSender = RemoteAuditSender.createRemoteAuditSender(new URL("http://dacian311"), notifier);
        remoteAuditSender.sendByUsernameAndSeries("dpitic", "1.1.1.17", AuditAction.EXPORT_DICOM_ACTION);
        remoteAuditSender.sendByUsernameAndSeries("dpitic", "1.1.1.18", AuditAction.EXPORT_DICOM_ACTION);
        remoteAuditSender.sendByUsernameAndSeries("dpitic", "1.1.1.19", AuditAction.EXPORT_DICOM_ACTION);
        remoteAuditSender.sendByUsernameAndSeries("dpitic", "1.1.1.20", AuditAction.EXPORT_DICOM_ACTION);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static class AuditMessage {
        private String mUserIdKey;
        private String mUserIdValue;
        private String mPatientIdKey;
        private String mPatientIdValue;
        private AuditAction mAction;

        private AuditMessage(String string, String string2) {
            this.mUserIdKey = string;
            this.mPatientIdKey = string2;
        }

        private void initAuditMessage(String string, String string2, AuditAction auditAction) {
            this.mUserIdValue = string;
            this.mPatientIdValue = string2;
            this.mAction = auditAction;
        }

        String getUserIdKey() {
            return this.mUserIdKey;
        }

        String getUserIdValue() {
            return this.mUserIdValue;
        }

        String getPatientIdKey() {
            return this.mPatientIdKey;
        }

        String getPatientIdValue() {
            return this.mPatientIdValue;
        }

        AuditAction getAction() {
            return this.mAction;
        }

        private static AuditMessage createByUserAndSeries() {
            return new AuditMessage("USERNAME", "SERIES_INSTANCE_UID");
        }

        private static AuditMessage createByAeTitleAndSeries() {
            return new AuditMessage("AE_TITLE", "SERIES_INSTANCE_UID");
        }

        private static AuditMessage createByUserAndStudy() {
            return new AuditMessage("USERNAME", "STUDY_INSTANCE_UID");
        }

        private static AuditMessage createByAeTitleAndStudy() {
            return new AuditMessage("AE_TITLE", "STUDY_INSTANCE_UID");
        }

        private static AuditMessage createByUserAndPatient() {
            return new AuditMessage("USERNAME", "PATIENT_ID");
        }

        private static AuditMessage createByAeTitleAndPatient() {
            return new AuditMessage("AE_TITLE", "PATIENT_ID");
        }

        private static AuditMessage createByUserAndAccession() {
            return new AuditMessage("USERNAME", "ACCESSION_NUMBER");
        }

        private static AuditMessage createByAeTitleAndAccession() {
            return new AuditMessage("AE_TITLE", "ACCESSION_NUMBER");
        }

        public String toString() {
            return super.toString() + ": " + this.mUserIdKey + "=" + this.mUserIdValue + ", " + this.mPatientIdKey + "=" + this.mPatientIdValue;
        }
    }
}

