/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.text;

import com.lowagie.text.Paragraph;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.text.RtfPhrase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfParagraph
extends RtfPhrase {
    public static final byte[] PARAGRAPH = "\\par".getBytes();
    public static final byte[] ALIGN_LEFT = "\\ql".getBytes();
    public static final byte[] ALIGN_RIGHT = "\\qr".getBytes();
    public static final byte[] ALIGN_CENTER = "\\qc".getBytes();
    public static final byte[] ALIGN_JUSTIFY = "\\qj".getBytes();
    public static final byte[] INDENT_LEFT = "\\li".getBytes();
    public static final byte[] INDENT_RIGHT = "\\ri".getBytes();
    private int alignment = -1;
    private int indentLeft = 0;
    private int indentRight = 0;

    public RtfParagraph(RtfDocument rtfDocument, Paragraph paragraph) {
        super(rtfDocument, paragraph);
        this.alignment = paragraph.alignment();
        this.indentLeft = (int)((double)paragraph.indentationLeft() * 20.0);
        this.indentRight = (int)((double)paragraph.indentationRight() * 20.0);
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(PARAGRAPH_DEFAULTS);
            if (this.inTable) {
                byteArrayOutputStream.write(IN_TABLE);
            }
            switch (this.alignment) {
                case 0: {
                    byteArrayOutputStream.write(ALIGN_LEFT);
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(ALIGN_RIGHT);
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(ALIGN_CENTER);
                    break;
                }
                case 3: 
                case 8: {
                    byteArrayOutputStream.write(ALIGN_JUSTIFY);
                }
            }
            byteArrayOutputStream.write(INDENT_LEFT);
            byteArrayOutputStream.write(this.intToByteArray(this.indentLeft));
            byteArrayOutputStream.write(INDENT_RIGHT);
            byteArrayOutputStream.write(this.intToByteArray(this.indentRight));
            for (int i = 0; i < this.chunks.size(); ++i) {
                byteArrayOutputStream.write(((RtfBasicElement)this.chunks.get(i)).write());
            }
            if (!this.inTable) {
                byteArrayOutputStream.write(PARAGRAPH);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

