/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.graphic;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.pdf.wmf.MetaDo;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.text.RtfParagraph;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class RtfImage
extends RtfElement {
    private static final byte[] PICTURE_GROUP = "\\*\\shppict".getBytes();
    private static final byte[] PICTURE = "\\pict".getBytes();
    private static final byte[] PICTURE_JPEG = "\\jpegblip".getBytes();
    private static final byte[] PICTURE_PNG = "\\pngblip".getBytes();
    private static final byte[] PICTURE_BMP = "\\dibitmap0".getBytes();
    private static final byte[] PICTURE_WMF = "\\wmetafile8".getBytes();
    private static final byte[] PICTURE_WIDTH = "\\picw".getBytes();
    private static final byte[] PICTURE_HEIGHT = "\\pich".getBytes();
    private static final byte[] PICTURE_SCALE_X = "\\picscalex".getBytes();
    private static final byte[] PICTURE_SCALE_Y = "\\picscaley".getBytes();
    private int imageType = 0;
    private byte[] image = new byte[0];
    private int alignment = 0;
    private float width = 0.0f;
    private float height = 0.0f;
    private float plainWidth = 0.0f;
    private float plainHeight = 0.0f;

    public RtfImage(RtfDocument rtfDocument, Image image) throws DocumentException {
        super(rtfDocument);
        this.imageType = image.getOriginalType();
        if (this.imageType != 1 && this.imageType != 4 && this.imageType != 2 && this.imageType != 6) {
            throw new DocumentException("Only BMP, PNG, WMF and JPEG images are supported by the RTF Writer");
        }
        this.alignment = image.alignment();
        this.width = image.width();
        this.height = image.height();
        this.plainWidth = image.plainWidth();
        this.plainHeight = image.plainHeight();
        this.image = this.getImage(image);
    }

    private byte[] getImage(Image image) throws DocumentException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            InputStream inputStream;
            if (this.imageType == 4) {
                inputStream = new ByteArrayInputStream(MetaDo.wrapBMP(image));
            } else {
                inputStream = image.getOriginalData() == null ? image.url().openStream() : new ByteArrayInputStream(image.getOriginalData());
                if (this.imageType == 6) {
                    for (long i = 22L; i > 0L; i -= inputStream.skip(i)) {
                    }
                }
            }
            int n = 0;
            int n2 = 0;
            while ((n = inputStream.read()) != -1) {
                String string = Integer.toHexString(n);
                if (string.length() < 2) {
                    string = "0" + string;
                }
                byteArrayOutputStream.write(string.getBytes());
                if (++n2 != 64) continue;
                byteArrayOutputStream.write(10);
                n2 = 0;
            }
        }
        catch (IOException iOException) {
            throw new DocumentException(iOException.getMessage());
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            switch (this.alignment) {
                case 0: {
                    byteArrayOutputStream.write(RtfParagraph.ALIGN_LEFT);
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(RtfParagraph.ALIGN_RIGHT);
                    break;
                }
                case 1: {
                    byteArrayOutputStream.write(RtfParagraph.ALIGN_CENTER);
                    break;
                }
                case 3: {
                    byteArrayOutputStream.write(RtfParagraph.ALIGN_JUSTIFY);
                }
            }
            byteArrayOutputStream.write(RtfBasicElement.OPEN_GROUP);
            byteArrayOutputStream.write(PICTURE_GROUP);
            byteArrayOutputStream.write(RtfBasicElement.OPEN_GROUP);
            byteArrayOutputStream.write(PICTURE);
            switch (this.imageType) {
                case 1: {
                    byteArrayOutputStream.write(PICTURE_JPEG);
                    break;
                }
                case 2: {
                    byteArrayOutputStream.write(PICTURE_PNG);
                    break;
                }
                case 4: 
                case 6: {
                    byteArrayOutputStream.write(PICTURE_WMF);
                }
            }
            byteArrayOutputStream.write(PICTURE_WIDTH);
            byteArrayOutputStream.write(this.intToByteArray((int)((double)this.plainWidth * 20.0)));
            byteArrayOutputStream.write(PICTURE_HEIGHT);
            byteArrayOutputStream.write(this.intToByteArray((int)((double)this.plainHeight * 20.0)));
            if (this.width > 0.0f) {
                byteArrayOutputStream.write(PICTURE_SCALE_X);
                byteArrayOutputStream.write(this.intToByteArray((int)(100.0f / this.width * this.plainWidth)));
            }
            if (this.height > 0.0f) {
                byteArrayOutputStream.write(PICTURE_SCALE_Y);
                byteArrayOutputStream.write(this.intToByteArray((int)(100.0f / this.height * this.plainHeight)));
            }
            byteArrayOutputStream.write(RtfBasicElement.DELIMITER);
            byteArrayOutputStream.write(10);
            byteArrayOutputStream.write(this.image);
            byteArrayOutputStream.write(RtfBasicElement.CLOSE_GROUP);
            byteArrayOutputStream.write(RtfBasicElement.CLOSE_GROUP);
            byteArrayOutputStream.write(10);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }
}

