/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf;

import com.lowagie.text.DocListener;
import com.lowagie.text.DocWriter;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Rectangle;
import com.lowagie.text.Watermark;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.text.RtfNewPage;
import java.io.IOException;
import java.io.OutputStream;

public class RtfWriter2
extends DocWriter
implements DocListener {
    RtfDocument rtfDoc = null;

    protected RtfWriter2(Document document, OutputStream outputStream) {
        super(document, outputStream);
        document.addDocListener(this);
        this.rtfDoc = new RtfDocument();
    }

    public static RtfWriter2 getInstance(Document document, OutputStream outputStream) {
        return new RtfWriter2(document, outputStream);
    }

    public void setHeader(HeaderFooter headerFooter) {
        this.rtfDoc.getDocumentHeader().setHeader(headerFooter);
    }

    public void resetHeader() {
        this.rtfDoc.getDocumentHeader().setHeader(null);
    }

    public void setFooter(HeaderFooter headerFooter) {
        this.rtfDoc.getDocumentHeader().setFooter(headerFooter);
    }

    public void resetFooter() {
        this.rtfDoc.getDocumentHeader().setFooter(null);
    }

    public void setPageCount(int n) {
    }

    public void resetPageCount() {
    }

    public boolean add(Watermark watermark) {
        return false;
    }

    public void removeWatermark() {
    }

    public void clearTextWrap() {
    }

    public void open() {
    }

    public void close() {
        try {
            this.os.write(this.rtfDoc.writeDocument());
            this.os.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean add(Element element) throws DocumentException {
        RtfBasicElement rtfBasicElement = this.rtfDoc.getMapper().mapElement(element);
        if (rtfBasicElement != null) {
            this.rtfDoc.add(rtfBasicElement);
            return true;
        }
        return false;
    }

    public boolean newPage() {
        this.rtfDoc.add(new RtfNewPage(this.rtfDoc));
        return true;
    }

    public boolean setMargins(float f, float f2, float f3, float f4) {
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginLeft((int)((double)f * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginRight((int)((double)f2 * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginTop((int)((double)f3 * 20.0));
        this.rtfDoc.getDocumentHeader().getPageSetting().setMarginBottom((int)((double)f4 * 20.0));
        return true;
    }

    public boolean setPageSize(Rectangle rectangle) {
        this.rtfDoc.getDocumentHeader().getPageSetting().setPageSize(rectangle);
        return true;
    }

    public void setAutogenerateTOCEntries(boolean bl) {
        this.rtfDoc.setAutogenerateTOCEntries(bl);
    }
}

