/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPCellEvent;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;

public class PdfPRow {
    public static final float BOTTOM_LIMIT = -1.0737418E9f;
    protected PdfPCell[] cells;
    protected float[] widths;
    protected float maxHeight = 0.0f;
    protected boolean calculated = false;

    public PdfPRow(PdfPCell[] pdfPCellArray) {
        this.cells = pdfPCellArray;
        this.widths = new float[pdfPCellArray.length];
    }

    public PdfPRow(PdfPRow pdfPRow) {
        this.maxHeight = pdfPRow.maxHeight;
        this.calculated = pdfPRow.calculated;
        this.cells = new PdfPCell[pdfPRow.cells.length];
        for (int i = 0; i < this.cells.length; ++i) {
            if (pdfPRow.cells[i] == null) continue;
            this.cells[i] = new PdfPCell(pdfPRow.cells[i]);
        }
        this.widths = new float[this.cells.length];
        System.arraycopy(pdfPRow.widths, 0, this.widths, 0, this.cells.length);
    }

    public boolean setWidths(float[] fArray) {
        if (fArray.length != this.cells.length) {
            return false;
        }
        System.arraycopy(fArray, 0, this.widths, 0, this.cells.length);
        float f = 0.0f;
        this.calculated = false;
        for (int i = 0; i < fArray.length; ++i) {
            PdfPCell pdfPCell = this.cells[i];
            pdfPCell.setLeft(f);
            int n = i + pdfPCell.getColspan();
            while (i < n) {
                f += fArray[i];
                ++i;
            }
            --i;
            pdfPCell.setRight(f);
            pdfPCell.setTop(0.0f);
        }
        return true;
    }

    public float calculateHeights() {
        this.maxHeight = 0.0f;
        for (int i = 0; i < this.cells.length; ++i) {
            float f;
            PdfPCell pdfPCell = this.cells[i];
            if (pdfPCell == null) continue;
            PdfPTable pdfPTable = pdfPCell.getTable();
            Image image = pdfPCell.getImage();
            if (image != null) {
                image.scalePercent(100.0f);
                f = (pdfPCell.right() - pdfPCell.getEffectivePaddingRight() - pdfPCell.getEffectivePaddingLeft() - pdfPCell.left()) / image.scaledWidth();
                image.scalePercent(f * 100.0f);
                pdfPCell.setBottom(pdfPCell.top() - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom() - image.scaledHeight());
            } else {
                f = pdfPCell.isNoWrap() ? 20000.0f : pdfPCell.right() - pdfPCell.getEffectivePaddingRight();
                float f2 = pdfPCell.getFixedHeight() > 0.0f ? pdfPCell.top() - pdfPCell.getEffectivePaddingTop() + pdfPCell.getEffectivePaddingBottom() - pdfPCell.getFixedHeight() : -1.0737418E9f;
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                columnText.setSimpleColumn(pdfPCell.left() + pdfPCell.getEffectivePaddingLeft(), f2, f, pdfPCell.top() - pdfPCell.getEffectivePaddingTop());
                try {
                    columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                float f3 = columnText.getYLine();
                if (pdfPCell.isUseDescender()) {
                    f3 += columnText.getDescender();
                }
                pdfPCell.setBottom(f3 - pdfPCell.getEffectivePaddingBottom());
            }
            f = pdfPCell.getFixedHeight();
            if (f <= 0.0f) {
                f = pdfPCell.height();
            }
            if (f < pdfPCell.getFixedHeight()) {
                f = pdfPCell.getFixedHeight();
            } else if (f < pdfPCell.getMinimumHeight()) {
                f = pdfPCell.getMinimumHeight();
            }
            if (!(f > this.maxHeight)) continue;
            this.maxHeight = f;
        }
        this.calculated = true;
        return this.maxHeight;
    }

    public void writeBorderAndBackgroung(float f, float f2, PdfPCell pdfPCell, PdfContentByte[] pdfContentByteArray) {
        PdfContentByte pdfContentByte = pdfContentByteArray[2];
        PdfContentByte pdfContentByte2 = pdfContentByteArray[1];
        float f3 = pdfPCell.left() + f;
        float f4 = pdfPCell.top() + f2;
        float f5 = pdfPCell.right() + f;
        float f6 = f4 - this.maxHeight;
        Color color = pdfPCell.backgroundColor();
        if (color != null) {
            pdfContentByte2.setColorFill(color);
            pdfContentByte2.rectangle(f3, f6, f5 - f3, f4 - f6);
            pdfContentByte2.fill();
        } else if (pdfPCell.grayFill() > 0.0f) {
            pdfContentByte2.setGrayFill(pdfPCell.grayFill());
            pdfContentByte2.rectangle(f3, f6, f5 - f3, f4 - f6);
            pdfContentByte2.fill();
        }
        if (pdfPCell.hasBorders()) {
            if (pdfPCell.isUseVariableBorders()) {
                Rectangle rectangle = new Rectangle(pdfPCell.left() + f, pdfPCell.top() - this.maxHeight + f2, pdfPCell.right() + f, pdfPCell.top() + f2);
                rectangle.cloneNonPositionParameters(pdfPCell);
                pdfContentByte.rectangle(rectangle);
            } else {
                Color color2;
                if (pdfPCell.borderWidth() != -1.0f) {
                    pdfContentByte.setLineWidth(pdfPCell.borderWidth());
                }
                if ((color2 = pdfPCell.borderColor()) != null) {
                    pdfContentByte.setColorStroke(color2);
                }
                if (pdfPCell.hasBorder(15)) {
                    pdfContentByte.rectangle(f3, f6, f5 - f3, f4 - f6);
                } else {
                    if (pdfPCell.hasBorder(8)) {
                        pdfContentByte.moveTo(f5, f6);
                        pdfContentByte.lineTo(f5, f4);
                    }
                    if (pdfPCell.hasBorder(4)) {
                        pdfContentByte.moveTo(f3, f6);
                        pdfContentByte.lineTo(f3, f4);
                    }
                    if (pdfPCell.hasBorder(2)) {
                        pdfContentByte.moveTo(f3, f6);
                        pdfContentByte.lineTo(f5, f6);
                    }
                    if (pdfPCell.hasBorder(1)) {
                        pdfContentByte.moveTo(f3, f4);
                        pdfContentByte.lineTo(f5, f4);
                    }
                }
                pdfContentByte.stroke();
                if (color2 != null) {
                    pdfContentByte.resetRGBColorStroke();
                }
            }
        }
    }

    public void writeCells(int n, int n2, float f, float f2, PdfContentByte[] pdfContentByteArray) {
        int n3;
        if (!this.calculated) {
            this.calculateHeights();
        }
        if (n2 < 0) {
            n2 = this.cells.length;
        }
        n2 = Math.min(n2, this.cells.length);
        if (n < 0) {
            n = 0;
        }
        if (n >= n2) {
            return;
        }
        for (n3 = n; n3 >= 0 && this.cells[n3] == null; --n3) {
            f -= this.widths[n3 - 1];
        }
        f -= this.cells[n3].left();
        for (int i = n3; i < n2; ++i) {
            float f3;
            PdfPCell pdfPCell = this.cells[i];
            if (pdfPCell == null) continue;
            this.writeBorderAndBackgroung(f, f2, pdfPCell, pdfContentByteArray);
            PdfPTable pdfPTable = pdfPCell.getTable();
            Image image = pdfPCell.getImage();
            float f4 = 0.0f;
            boolean bl = false;
            switch (pdfPCell.getVerticalAlignment()) {
                case 6: {
                    f4 = pdfPCell.top() + f2 - this.maxHeight + pdfPCell.height() - pdfPCell.getEffectivePaddingTop();
                    break;
                }
                case 5: {
                    f4 = pdfPCell.top() + f2 + (pdfPCell.height() - this.maxHeight) / 2.0f - pdfPCell.getEffectivePaddingTop();
                    break;
                }
                default: {
                    bl = true;
                    f4 = pdfPCell.top() + f2 - pdfPCell.getEffectivePaddingTop();
                }
            }
            if (image != null) {
                boolean bl2 = false;
                if (pdfPCell.height() > this.maxHeight) {
                    image.scalePercent(100.0f);
                    f3 = (this.maxHeight - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom()) / image.scaledHeight();
                    image.scalePercent(f3 * 100.0f);
                    bl2 = true;
                }
                f3 = pdfPCell.left() + f + pdfPCell.getEffectivePaddingLeft();
                if (bl2) {
                    switch (pdfPCell.getHorizontalAlignment()) {
                        case 1: {
                            f3 = f + (pdfPCell.left() + pdfPCell.getEffectivePaddingLeft() + pdfPCell.right() - pdfPCell.getEffectivePaddingRight() - image.scaledWidth()) / 2.0f;
                            break;
                        }
                        case 2: {
                            f3 = f + pdfPCell.right() - pdfPCell.getEffectivePaddingRight() - image.scaledWidth();
                            break;
                        }
                    }
                    f4 = pdfPCell.top() + f2 - pdfPCell.getEffectivePaddingTop();
                }
                image.setAbsolutePosition(f3, f4 - image.scaledHeight());
                try {
                    pdfContentByteArray[3].addImage(image);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            float f5 = pdfPCell.getFixedHeight();
            f3 = pdfPCell.right() + f - pdfPCell.getEffectivePaddingRight();
            float f6 = pdfPCell.left() + f + pdfPCell.getEffectivePaddingLeft();
            if (pdfPCell.isNoWrap()) {
                switch (pdfPCell.getHorizontalAlignment()) {
                    case 1: {
                        f3 += 10000.0f;
                        f6 -= 10000.0f;
                        break;
                    }
                    case 2: {
                        f6 -= 20000.0f;
                        break;
                    }
                    default: {
                        f3 += 20000.0f;
                    }
                }
            }
            ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
            columnText.setCanvas(pdfContentByteArray[3]);
            float f7 = f4 - (this.maxHeight - pdfPCell.getEffectivePaddingTop() - pdfPCell.getEffectivePaddingBottom());
            if (f5 > 0.0f && pdfPCell.height() > this.maxHeight) {
                f4 = pdfPCell.top() + f2 - pdfPCell.getEffectivePaddingTop();
                f7 = pdfPCell.top() + f2 - this.maxHeight + pdfPCell.getEffectivePaddingBottom();
            }
            if (f4 > f7 || columnText.zeroHeightElement()) {
                columnText.setSimpleColumn(f6, f7 - 0.001f, f3, f4);
                try {
                    columnText.go();
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
            }
            PdfPCellEvent pdfPCellEvent = pdfPCell.getCellEvent();
            if (pdfPCellEvent == null) continue;
            Rectangle rectangle = new Rectangle(pdfPCell.left() + f, pdfPCell.top() + f2 - this.maxHeight, pdfPCell.right() + f, pdfPCell.top() + f2);
            pdfPCellEvent.cellLayout(pdfPCell, rectangle, pdfContentByteArray);
        }
    }

    public boolean isCalculated() {
        return this.calculated;
    }

    public float getMaxHeights() {
        if (this.calculated) {
            return this.maxHeight;
        }
        return this.calculateHeights();
    }

    public void setMaxHeights(float f) {
        this.maxHeight = f;
    }

    float[] getEventWidth(float f) {
        int n = 0;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            ++n;
        }
        float[] fArray = new float[n + 1];
        n = 0;
        fArray[n++] = f;
        for (int i = 0; i < this.cells.length; ++i) {
            if (this.cells[i] == null) continue;
            fArray[n] = fArray[n - 1] + this.cells[i].width();
            ++n;
        }
        return fArray;
    }

    public PdfPRow splitRow(float f) {
        PdfPCell pdfPCell;
        int n;
        PdfPCell[] pdfPCellArray = new PdfPCell[this.cells.length];
        float[] fArray = new float[this.cells.length * 2];
        boolean bl = true;
        for (n = 0; n < this.cells.length; ++n) {
            pdfPCell = this.cells[n];
            if (pdfPCell == null) continue;
            fArray[n * 2] = pdfPCell.getFixedHeight();
            fArray[n * 2 + 1] = pdfPCell.getMinimumHeight();
            Image image = pdfPCell.getImage();
            PdfPCell pdfPCell2 = new PdfPCell(pdfPCell);
            if (image != null) {
                if (f > pdfPCell.getEffectivePaddingBottom() + pdfPCell.getEffectivePaddingTop() + 2.0f) {
                    pdfPCell2.setPhrase(null);
                    bl = false;
                }
            } else {
                boolean bl2;
                int n2;
                float f2 = pdfPCell.isNoWrap() ? 20000.0f : pdfPCell.right() - pdfPCell.getEffectivePaddingRight();
                ColumnText columnText = ColumnText.duplicate(pdfPCell.getColumn());
                float f3 = pdfPCell.top() - pdfPCell.getEffectivePaddingTop();
                columnText.setSimpleColumn(pdfPCell.left() + pdfPCell.getEffectivePaddingLeft(), pdfPCell.top() - f + pdfPCell.getEffectivePaddingBottom(), f2, f3);
                try {
                    n2 = columnText.go(true);
                }
                catch (DocumentException documentException) {
                    throw new ExceptionConverter(documentException);
                }
                boolean bl3 = bl2 = columnText.getYLine() == f3;
                if (bl2) {
                    columnText = ColumnText.duplicate(pdfPCell.getColumn());
                }
                boolean bl4 = bl = bl && bl2;
                if ((n2 & 1) == 0 || bl2) {
                    pdfPCell2.setColumn(columnText);
                } else {
                    pdfPCell2.setPhrase(null);
                }
            }
            pdfPCellArray[n] = pdfPCell2;
            pdfPCell.setFixedHeight(f);
        }
        if (bl) {
            for (n = 0; n < this.cells.length; ++n) {
                pdfPCell = this.cells[n];
                if (pdfPCell == null) continue;
                float f4 = fArray[n * 2];
                float f5 = fArray[n * 2 + 1];
                if (f4 <= 0.0f) {
                    pdfPCell.setMinimumHeight(f5);
                    continue;
                }
                pdfPCell.setFixedHeight(f4);
            }
            return null;
        }
        this.calculateHeights();
        PdfPRow pdfPRow = new PdfPRow(pdfPCellArray);
        pdfPRow.widths = (float[])this.widths.clone();
        pdfPRow.calculateHeights();
        return pdfPRow;
    }
}

