/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Document;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncryption;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.DeflaterOutputStream;

public class PRStream
extends PdfStream {
    protected PdfReader reader;
    protected int offset;
    protected int length;
    protected int objNum = 0;
    protected int objGen = 0;

    public PRStream(PRStream pRStream, PdfDictionary pdfDictionary) {
        this.reader = pRStream.reader;
        this.offset = pRStream.offset;
        this.length = pRStream.length;
        this.compressed = pRStream.compressed;
        this.streamBytes = pRStream.streamBytes;
        this.bytes = pRStream.bytes;
        this.objNum = pRStream.objNum;
        this.objGen = pRStream.objGen;
        if (pdfDictionary != null) {
            this.putAll(pdfDictionary);
        } else {
            this.hashMap.putAll(pRStream.hashMap);
        }
    }

    public PRStream(PRStream pRStream, PdfDictionary pdfDictionary, PdfReader pdfReader) {
        this(pRStream, pdfDictionary);
        this.reader = pdfReader;
    }

    public PRStream(PdfReader pdfReader, int n) {
        this.reader = pdfReader;
        this.offset = n;
    }

    public PRStream(PdfReader pdfReader, byte[] byArray) {
        this.reader = pdfReader;
        this.offset = -1;
        if (Document.compress) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
                deflaterOutputStream.write(byArray);
                deflaterOutputStream.close();
                this.bytes = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        } else {
            this.bytes = byArray;
        }
        this.setLength(this.bytes.length);
    }

    public void setData(byte[] byArray) {
        this.remove(PdfName.FILTER);
        this.offset = -1;
        if (Document.compress) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
                deflaterOutputStream.write(byArray);
                deflaterOutputStream.close();
                this.bytes = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
            this.put(PdfName.FILTER, PdfName.FLATEDECODE);
        } else {
            this.bytes = byArray;
        }
        this.setLength(this.bytes.length);
    }

    public void setLength(int n) {
        this.length = n;
        this.put(PdfName.LENGTH, new PdfNumber(n));
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public PdfReader getReader() {
        return this.reader;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setObjNum(int n, int n2) {
        this.objNum = n;
        this.objGen = n2;
    }

    int getObjNum() {
        return this.objNum;
    }

    int getObjGen() {
        return this.objGen;
    }

    public void toPdf(PdfWriter pdfWriter, OutputStream outputStream) throws IOException {
        this.superToPdf(pdfWriter, outputStream);
        outputStream.write(STARTSTREAM);
        if (this.length > 0) {
            PdfEncryption pdfEncryption = null;
            if (pdfWriter != null) {
                pdfEncryption = pdfWriter.getEncryption();
            }
            if (this.offset < 0) {
                if (pdfEncryption == null) {
                    outputStream.write(this.bytes);
                } else {
                    pdfEncryption.prepareKey();
                    byte[] byArray = new byte[this.length];
                    System.arraycopy(this.bytes, 0, byArray, 0, this.length);
                    pdfEncryption.encryptRC4(byArray);
                    outputStream.write(byArray);
                }
            } else {
                byte[] byArray = new byte[Math.min(this.length, 4092)];
                RandomAccessFileOrArray randomAccessFileOrArray = pdfWriter.getReaderFile(this.reader);
                randomAccessFileOrArray.seek(this.offset);
                int n = this.length;
                PdfEncryption pdfEncryption2 = this.reader.getDecrypt();
                if (pdfEncryption2 != null) {
                    pdfEncryption2.setHashKey(this.objNum, this.objGen);
                    pdfEncryption2.prepareKey();
                }
                if (pdfEncryption != null) {
                    pdfEncryption.prepareKey();
                }
                while (n > 0) {
                    int n2 = randomAccessFileOrArray.read(byArray, 0, Math.min(n, byArray.length));
                    n -= n2;
                    if (pdfEncryption2 != null) {
                        pdfEncryption2.encryptRC4(byArray, 0, n2);
                    }
                    if (pdfEncryption != null) {
                        pdfEncryption.encryptRC4(byArray, 0, n2);
                    }
                    outputStream.write(byArray, 0, n2);
                }
            }
        }
        outputStream.write(ENDSTREAM);
    }
}

