/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsDevice;
import java.awt.print.PrinterJob;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import sun.awt.DisplayChangedListener;
import sun.awt.FontConfiguration;
import sun.awt.Win32GraphicsDevice;
import sun.awt.windows.WFontConfiguration;
import sun.awt.windows.WPrinterJob;
import sun.awt.windows.WToolkit;
import sun.font.FontManager;
import sun.java2d.SunGraphicsEnvironment;
import sun.java2d.windows.WindowsFlags;

public class Win32GraphicsEnvironment
extends SunGraphicsEnvironment {
    private static boolean displayInitialized;
    private ArrayList<WeakReference<Win32GraphicsDevice>> oldDevices;
    static String fontsForPrinting;

    public static void init() {
    }

    private static native void initDisplay();

    public static void initDisplayWrapper() {
        if (!displayInitialized) {
            displayInitialized = true;
            Win32GraphicsEnvironment.initDisplay();
        }
    }

    protected native int getNumScreens();

    protected native int getDefaultScreen();

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[this.getDefaultScreen()];
    }

    public native int getXResolution();

    public native int getYResolution();

    public void displayChanged() {
        int n;
        GraphicsDevice[] graphicsDeviceArray = new GraphicsDevice[this.getNumScreens()];
        for (n = 0; n < this.screens.length; ++n) {
            if (!(this.screens[n] instanceof Win32GraphicsDevice)) {
                assert (false) : this.screens[n];
                continue;
            }
            Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)this.screens[n];
            if (!win32GraphicsDevice.isValid()) {
                if (this.oldDevices == null) {
                    this.oldDevices = new ArrayList();
                }
                this.oldDevices.add(new WeakReference<Win32GraphicsDevice>(win32GraphicsDevice));
                continue;
            }
            if (n >= graphicsDeviceArray.length) continue;
            graphicsDeviceArray[n] = win32GraphicsDevice;
        }
        for (n = 0; n < graphicsDeviceArray.length; ++n) {
            if (graphicsDeviceArray[n] != null) continue;
            graphicsDeviceArray[n] = this.makeScreenDevice(n);
        }
        for (GraphicsDevice graphicsDevice : this.screens = graphicsDeviceArray) {
            if (!(graphicsDevice instanceof DisplayChangedListener)) continue;
            ((DisplayChangedListener)((Object)graphicsDevice)).displayChanged();
        }
        if (this.oldDevices != null) {
            int n2 = this.getDefaultScreen();
            ListIterator listIterator = this.oldDevices.listIterator();
            while (listIterator.hasNext()) {
                Win32GraphicsDevice win32GraphicsDevice = (Win32GraphicsDevice)((WeakReference)listIterator.next()).get();
                if (win32GraphicsDevice != null) {
                    win32GraphicsDevice.invalidate(n2);
                    win32GraphicsDevice.displayChanged();
                    continue;
                }
                listIterator.remove();
            }
        }
        WToolkit.resetGC();
        this.displayChanger.notifyListeners();
    }

    private static native String getEUDCFontFile();

    protected boolean useAbsoluteFontFileNames() {
        return false;
    }

    protected void registerFontFile(String string, String[] stringArray, int n, boolean bl) {
        int n2;
        if (this.registeredFontFiles.contains(string)) {
            return;
        }
        this.registeredFontFiles.add(string);
        if (ttFilter.accept(null, string)) {
            n2 = 0;
        } else if (t1Filter.accept(null, string)) {
            n2 = 1;
        } else {
            return;
        }
        if (this.fontPath == null) {
            this.fontPath = this.getPlatformFontPath(noType1Font);
        }
        String string2 = jreFontDirName + File.pathSeparator + this.fontPath;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        boolean bl2 = false;
        try {
            while (!bl2 && stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                File file = new File(string3, string);
                if (!file.canRead()) continue;
                bl2 = true;
                String string4 = file.getAbsolutePath();
                if (bl) {
                    FontManager.registerDeferredFont(string, string4, stringArray, n2, true, n);
                } else {
                    FontManager.registerFontFile(string4, stringArray, n2, true, n);
                }
                break;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
        if (!bl2) {
            this.addToMissingFontFileList(string);
        }
    }

    protected void registerJREFontsWithPlatform(String string) {
        fontsForPrinting = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerJREFontsForPrinting() {
        String string = null;
        Object object = Win32GraphicsEnvironment.class;
        synchronized (Win32GraphicsEnvironment.class) {
            if (fontsForPrinting == null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            string = fontsForPrinting;
            fontsForPrinting = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            object = new File(string);
            String[] stringArray = ((File)object).list(new SunGraphicsEnvironment.TTFilter());
            if (stringArray == null) {
                return;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                File file = new File((File)object, stringArray[i]);
                Win32GraphicsEnvironment.registerFontWithPlatform(file.getAbsolutePath());
            }
            return;
        }
    }

    protected static native void registerFontWithPlatform(String var0);

    protected static native void deRegisterFontWithPlatform(String var0);

    protected GraphicsDevice makeScreenDevice(int n) {
        return new Win32GraphicsDevice(n);
    }

    public PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new WPrinterJob();
    }

    protected FontConfiguration createFontConfiguration() {
        return new WFontConfiguration(this);
    }

    public FontConfiguration createFontConfiguration(boolean bl, boolean bl2) {
        return new WFontConfiguration(this, bl, bl2);
    }

    static {
        WToolkit.loadLibraries();
        WindowsFlags.initFlags();
        Win32GraphicsEnvironment.initDisplayWrapper();
        eudcFontFileName = Win32GraphicsEnvironment.getEUDCFontFile();
        fontsForPrinting = null;
    }
}

