/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDict;
import com.archimed.dicom.DicomException;
import com.archimed.dicom.DicomObject;
import com.archimed.dicom.Jdt;
import com.archimed.dicom.TagReadEvent;
import com.archimed.dicom.TagReadListener;
import com.archimed.dicom.UID;
import com.archimed.dicom.UnknownUIDException;
import com.archimed.dicom.c;
import com.archimed.dicom.q;
import com.archimed.log.JdtLogger;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;

public class DicomReader {
    protected JdtLogger log = Jdt.getJdtLoggerFactory().getJdtLogger(DicomReader.class);
    private HashMap a = new HashMap();

    public void addTagReadListener(TagReadListener tagReadListener, int n2) {
        this.addTagReadListener(tagReadListener, DDict.getGroup(n2), DDict.getElement(n2));
    }

    public synchronized void addTagReadListener(TagReadListener tagReadListener, int n2, int n3) {
        Integer n4 = new Integer(n2 * 65535 + n3);
        Vector<TagReadListener> vector = (Vector<TagReadListener>)this.a.get(n4);
        if (vector == null) {
            vector = new Vector<TagReadListener>();
            this.a.put(n4, vector);
        }
        vector.add(tagReadListener);
    }

    public synchronized void removeTagReadListener(TagReadListener tagReadListener, int n2) {
        this.removeTagReadListener(tagReadListener, DDict.getGroup(n2), DDict.getElement(n2));
    }

    public synchronized void removeTagReadListener(TagReadListener tagReadListener, int n2, int n3) {
        Integer n4 = new Integer(n2 * 65535 + n3);
        Vector vector = (Vector)this.a.get(n4);
        if (vector == null) {
            return;
        }
        vector.remove(tagReadListener);
    }

    public DicomObject read(InputStream inputStream) throws IOException, DicomException {
        return this.read(inputStream, true);
    }

    public DicomObject read(InputStream inputStream, int n2, boolean bl) throws IOException, DicomException {
        DicomObject dicomObject = new DicomObject();
        q q2 = new q(inputStream);
        this.readDICOMStream(dicomObject, q2, n2, bl);
        return dicomObject;
    }

    public DicomObject read(InputStream inputStream, boolean bl) throws IOException, DicomException {
        DicomObject dicomObject = new DicomObject();
        this.read(dicomObject, inputStream, bl);
        return dicomObject;
    }

    TagReadEvent fireAfterReadHeader(DicomObject dicomObject, int n2, int n3, int n4, int n5, InputStream inputStream) {
        Integer n6 = new Integer(n2 * 65535 + n3);
        Vector vector = (Vector)this.a.get(n6);
        if (vector == null || vector.size() == 0) {
            return null;
        }
        TagReadEvent tagReadEvent = new TagReadEvent(dicomObject, n2, n3, n4, n5, inputStream);
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            ((TagReadListener)vector.get(i2)).afterHeader(tagReadEvent);
        }
        return tagReadEvent;
    }

    void read(DicomObject dicomObject, InputStream inputStream, boolean bl) throws IOException, DicomException {
        boolean bl2;
        InputStream inputStream2 = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
        inputStream2.mark(256);
        try {
            bl2 = this.checkIfDicomFile(inputStream2);
        }
        catch (Exception exception) {
            bl2 = false;
        }
        inputStream2.reset();
        q q2 = new q(inputStream2);
        if (bl2) {
            long l2 = this.readHeader(dicomObject, q2);
            if (l2 == -1L) {
                return;
            }
            this.readDICOMStream(dicomObject, q2, 8193, bl);
        } else {
            this.readDICOMStream(dicomObject, q2, 8193, bl);
        }
    }

    boolean checkIfDicomFile(InputStream inputStream) throws IOException, DicomException {
        byte[] byArray = new byte[128];
        byte[] byArray2 = new byte[4];
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        try {
            dataInputStream.readFully(byArray);
            dataInputStream.readFully(byArray2);
        }
        catch (EOFException eOFException) {
            this.log.warn("EOFException before reading 132 bytes: not a DICOM file");
            return false;
        }
        return new String(byArray2).equals("DICM");
    }

    void readDICOMStream(DicomObject dicomObject, q q2, int n2, boolean bl) throws IOException, DicomException {
        this.log.debug("DicomObject.readDICOMStream.");
        DicomObject dicomObject2 = dicomObject.getFileMetaInformation();
        if (dicomObject2 != null) {
            try {
                n2 = UID.getUIDEntry(dicomObject2.getS(31).trim()).getConstant();
            }
            catch (UnknownUIDException unknownUIDException) {
                n2 = 8192;
            }
        }
        q2.for(n2);
        this.readTags(dicomObject, q2, bl);
        if (n2 == 8193 || n2 == 8227) {
            boolean bl2 = this.a(dicomObject);
        }
    }

    long readHeader(DicomObject dicomObject, q q2) throws IOException, DicomException {
        this.log.debug("DicomObject.readHeader.");
        byte[] byArray = new byte[128];
        byte[] byArray2 = new byte[4];
        q2.for(8194);
        q2.a(byArray);
        q2.a(byArray2);
        if (byArray2[0] != 68 || byArray2[1] != 73 || byArray2[2] != 67 || byArray2[3] != 77) {
            throw new DicomException("Not a valid Dicom-file");
        }
        DicomObject dicomObject2 = new DicomObject();
        dicomObject.setFileMetaInformation(dicomObject2);
        int n2 = 8192;
        while (true) {
            int n3 = q2.int();
            q2.do(n3);
            if (n3 != 2) break;
            c c2 = new c();
            int n4 = c2.a(dicomObject2, this, q2, true);
            if (!this.a(dicomObject2, c2, n4)) {
                return -1L;
            }
            if (c2.getGroup() != 2 || c2.getElement() != 16) continue;
            try {
                String string = dicomObject2.getS(31);
                n2 = UID.getUIDEntry(string.trim()).getConstant();
            }
            catch (UnknownUIDException unknownUIDException) {
                n2 = 8192;
            }
        }
        q2.for(n2);
        return q2.if();
    }

    /*
     * Exception decompiling
     */
    void readTags(DicomObject var1_1, q var2_2, boolean var3_3) throws IOException, DicomException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean a(DicomObject dicomObject, c c2, int n2) {
        switch (n2) {
            case 1: {
                dicomObject.push(c2);
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                dicomObject.push(c2);
                return false;
            }
            case 4: {
                return false;
            }
        }
        return false;
    }

    private boolean a(DicomObject dicomObject) {
        boolean bl = false;
        bl = this.a(dicomObject, 1184);
        bl = this.a(dicomObject, 1505);
        bl = this.a(dicomObject, 498);
        bl = this.a(dicomObject, 499);
        bl = this.a(dicomObject, 500);
        bl = this.a(dicomObject, 501);
        bl = this.a(dicomObject, 502);
        bl = this.a(dicomObject, 503);
        for (int i2 = 0; i2 < 64; ++i2) {
            bl = this.a(dicomObject, 24576 + i2, 12288, 24);
            bl = this.a(dicomObject, 20480 + i2, 12288, 8);
            c c2 = dicomObject.getVR(20480 + i2, 8194);
            bl = c2 != null && c2.getValue() != null && (Integer)c2.getValue() == 0 ? this.a(dicomObject, 20480, 8204, 24) : this.a(dicomObject, 20480, 8204, 8);
        }
        return bl;
    }

    private boolean a(DicomObject dicomObject, int n2) {
        int n3 = DDict.getGroup(n2);
        int n4 = DDict.getElement(n2);
        return this.a(dicomObject, n3, n4, 24);
    }

    private boolean a(DicomObject dicomObject, int n2, int n3, int n4) {
        c c2 = dicomObject.getVR(n2, n3);
        if (c2 != null && c2.try == 22) {
            c2.try = n4;
            return true;
        }
        return false;
    }
}

