/*
 * Decompiled with CFR 0.152.
 */
package com.archimed.dicom;

import com.archimed.dicom.DDate;
import java.text.DateFormat;

public class DDateRange {
    DDate d1;
    DDate d2;

    public DDateRange(DDate dDate, DDate dDate2) {
        this.d1 = dDate != null ? dDate : new DDate();
        this.d2 = dDate2 != null ? dDate2 : new DDate();
    }

    public DDateRange(String string) throws NumberFormatException {
        int n2 = string.indexOf(45);
        if (n2 == -1) {
            throw new NumberFormatException(string + " cannot parse this string into DDateRange");
        }
        this.d1 = new DDate(string.substring(0, n2));
        this.d2 = new DDate(string.substring(n2 + 1));
    }

    public String toString() {
        return this.d1.toString() + " - " + this.d2.toString();
    }

    public String toString(DateFormat dateFormat) {
        return this.d1.toString(dateFormat) + " - " + this.d2.toString(dateFormat);
    }

    public String toDICOMString() {
        return this.d1.toDICOMString() + "-" + this.d2.toDICOMString();
    }

    public DDate getDate1() {
        if (!this.d1.isEmpty()) {
            return this.d1;
        }
        return null;
    }

    public DDate getDate2() {
        if (!this.d2.isEmpty()) {
            return this.d2;
        }
        return null;
    }
}

