/*
 * Decompiled with CFR 0.152.
 */
package com.intelerad.tools.lib.concurrent;

import RuntimeTool.DebugManager;
import com.intelerad.tools.lib.concurrent.CallListener;
import com.intelerad.tools.lib.concurrent.Callable;
import com.intelerad.tools.lib.concurrent.Cancellable;
import com.intelerad.tools.lib.concurrent.CancellationException;
import com.intelerad.tools.lib.concurrent.ExecutionException;
import com.intelerad.tools.lib.concurrent.FunctionResult;
import com.intelerad.tools.lib.concurrent.Invoker;
import com.intelerad.tools.lib.concurrent.TaskController;

public final class BasicTaskController
implements TaskController {
    private CallListener mListener;
    private Invoker mInvoker;
    private boolean mTaskHasReturnedAResult;
    private boolean mCommittedToAResult;
    private boolean mCancelled;
    private Object mResult;
    private Throwable mException;
    private Cancellable mCancellable;
    private FunctionResult mGetFunctionResult;

    public final synchronized void setResult(Object object) {
        if (this.hasTaskReturnedAResult()) {
            return;
        }
        this.mResult = object;
        this.fireRunnableIfNeeded();
    }

    public final synchronized void setException(Throwable throwable) {
        if (this.hasTaskReturnedAResult()) {
            return;
        }
        boolean bl = throwable instanceof Error;
        if (!bl && !(throwable instanceof Exception)) {
            throw new IllegalArgumentException("Throwable argument must be either an exception or an Error - " + throwable);
        }
        this.mException = bl ? new UnexpectedErrorException(throwable) : throwable;
        this.fireRunnableIfNeeded();
    }

    final synchronized boolean hasTaskReturnedAResult() {
        return this.mTaskHasReturnedAResult;
    }

    private final synchronized void fireRunnableIfNeeded() {
        if (this.hasTaskReturnedAResult()) {
            return;
        }
        this.mTaskHasReturnedAResult = true;
        this.notifyAll();
        Runnable runnable = new Runnable(this){
            final /* synthetic */ BasicTaskController this$0;

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void run() {
                try {
                    BasicTaskController.access$1(this.this$0).run();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    BasicTaskController.access$0(this.this$0).handleFinally();
                    throw throwable;
                }
                {
                    Object var2_3 = null;
                    BasicTaskController.access$0(this.this$0).handleFinally();
                    return;
                }
            }
            {
                this.this$0 = basicTaskController;
            }
        };
        this.mInvoker.invoke(runnable);
    }

    private final Runnable getRunnable() {
        try {
            Object object = this.getPrivate();
            return new Runnable(this, object){
                final /* synthetic */ BasicTaskController this$0;
                final /* synthetic */ Object val$result;

                public final void run() {
                    BasicTaskController.access$0(this.this$0).handleSuccess(this.val$result);
                }
                {
                    this.this$0 = basicTaskController;
                    this.val$result = object;
                }
            };
        }
        catch (CancellationException cancellationException) {
            return new Runnable(this){
                final /* synthetic */ BasicTaskController this$0;

                public final void run() {
                    BasicTaskController.access$0(this.this$0).handleCancel();
                }
                {
                    this.this$0 = basicTaskController;
                }
            };
        }
        catch (ExecutionException executionException) {
            return new Runnable(this, executionException){
                final /* synthetic */ BasicTaskController this$0;
                final /* synthetic */ ExecutionException val$ex;

                public final void run() {
                    if (this.val$ex.getCause() instanceof Exception) {
                        BasicTaskController.access$0(this.this$0).handleException((Exception)this.val$ex.getCause());
                    } else {
                        BasicTaskController.access$0(this.this$0).handleException(this.val$ex);
                    }
                }
                {
                    this.this$0 = basicTaskController;
                    this.val$ex = executionException;
                }
            };
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void cancel() {
        BasicTaskController basicTaskController = this;
        synchronized (basicTaskController) {
            if (this.mCommittedToAResult) {
                return;
            }
            if (this.mCancelled) {
                return;
            }
            this.mCancelled = true;
            this.fireRunnableIfNeeded();
        }
        try {
            this.mCancellable.cancel();
            return;
        }
        catch (Throwable throwable) {
            DebugManager.getDefault().printException("Unexpected exception while cancelling", throwable);
        }
    }

    public final synchronized Object get() throws ExecutionException, InterruptedException {
        while (!this.hasTaskReturnedAResult()) {
            this.wait();
        }
        return this.getPrivate();
    }

    private final synchronized Object getPrivate() throws ExecutionException, CancellationException {
        this.mCommittedToAResult = true;
        if (this.mGetFunctionResult == null) {
            Callable callable = new Callable(this){
                final /* synthetic */ BasicTaskController this$0;

                public final Object call() throws Exception {
                    if (this.this$0.isCancelled()) {
                        throw new CancellationException();
                    }
                    if (BasicTaskController.access$2(this.this$0) != null) {
                        throw new ExecutionException(BasicTaskController.access$2(this.this$0));
                    }
                    return BasicTaskController.access$3(this.this$0);
                }
                {
                    this.this$0 = basicTaskController;
                }
            };
            this.mGetFunctionResult = FunctionResult.saveFunctionResult(callable);
        }
        try {
            return this.mGetFunctionResult.call();
        }
        catch (ExecutionException executionException) {
            throw executionException;
        }
        catch (CancellationException cancellationException) {
            throw cancellationException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public final synchronized boolean isCancelled() {
        return this.mCancelled;
    }

    public final synchronized boolean isDone() {
        return this.mTaskHasReturnedAResult;
    }

    static /* synthetic */ CallListener access$0(BasicTaskController basicTaskController) {
        return basicTaskController.mListener;
    }

    static /* synthetic */ Runnable access$1(BasicTaskController basicTaskController) {
        return basicTaskController.getRunnable();
    }

    static /* synthetic */ Throwable access$2(BasicTaskController basicTaskController) {
        return basicTaskController.mException;
    }

    static /* synthetic */ Object access$3(BasicTaskController basicTaskController) {
        return basicTaskController.mResult;
    }

    public BasicTaskController(Cancellable cancellable, CallListener callListener, Invoker invoker) {
        if (invoker == Invoker.SYNCHRONOUS_INVOKER) {
            throw new IllegalArgumentException("The synchronous invoker can never, ever, under any circumstances be used with the BasicTaskController. Ever. See Invoker and CallListener javadocs.");
        }
        this.mListener = callListener;
        this.mCancellable = cancellable;
        this.mInvoker = invoker;
    }

    private static class UnexpectedErrorException
    extends RuntimeException {
        public UnexpectedErrorException(Throwable throwable) {
            super(throwable);
        }
    }
}

