/*
 * Decompiled with CFR 0.152.
 */
package StringUtilities;

import StringUtilities.StringEscape;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;

public class StringConverter {
    private static final char[] HEX_CHARS = "0123456789abcdef".toCharArray();

    public static String getPaddedString(String string, char c, int n) {
        if (string.length() > n) {
            return string;
        }
        char[] cArray = new char[n];
        int n2 = 0;
        while (n2 < n) {
            cArray[n2] = c;
            ++n2;
        }
        return new String(cArray, 0, n - string.length()).concat(string);
    }

    public static String getStringDecAscii(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = 0;
        while (n < string.length()) {
            stringBuffer.append((int)string.charAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String getStringDecAsciiNonNumeric(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isDigit(c)) {
                stringBuffer.append(c);
            } else {
                stringBuffer.append((int)string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static int getIntFromHexString(String string) throws NumberFormatException {
        if (string.startsWith("0x") || string.startsWith("0X")) {
            return Integer.parseInt(string.substring(2), 16);
        }
        return Integer.parseInt(string, 16);
    }

    public static int parseInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    public static double parseDouble(String string, double d) {
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    public static String hexString(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            if (n2 < 0) {
                n2 = 256 + n2;
            }
            cArray[2 * n] = HEX_CHARS[n2 >> 4];
            cArray[2 * n + 1] = HEX_CHARS[n2 & 0xF];
            ++n;
        }
        return new String(cArray);
    }

    public static byte[] unhexString(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException("input string has odd number of characters: '" + string + '\'');
        }
        byte[] byArray = new byte[string.length() / 2];
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            int n2 = Character.digit(c, 16);
            if (n2 == -1) {
                throw new IllegalArgumentException("invalid hex digit '" + c + "' in string '" + string + '\'');
            }
            if (n % 2 == 0) {
                byArray[n / 2] = (byte)(n2 << 4);
            } else {
                int n3 = n / 2;
                byArray[n3] = (byte)(byArray[n3] | (byte)n2);
            }
            ++n;
        }
        return byArray;
    }

    public static String makeSqlTuple(String[] stringArray) {
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("empty array not allowed (would generate bad SQL)");
        }
        return StringConverter.makeSqlTuple(Arrays.asList(stringArray));
    }

    public static String makeSqlTuple(Collection collection) {
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("empty collection not allowed (would generate bad SQL)");
        }
        StringBuffer stringBuffer = new StringBuffer("(");
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            string = StringEscape.escapeCharacters(string, "'", "'");
            stringBuffer.append("'").append(string).append("'");
            if (!iterator.hasNext()) continue;
            stringBuffer.append(",");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

