/*
 * Decompiled with CFR 0.152.
 */
package ReportViewerLibrary.Gui;

import ReportViewerLibrary.Gui.OrderStatusProvider;
import ReportViewerLibrary.Gui.ReportViewer;
import ReportViewerLibrary.Util.ReportViewerUtil;
import ReportViewerXml.OrderHeader;
import ReportViewerXml.OrderHeaderList;
import RuntimeTool.DebugManager;
import StringUtilities.StringCheck;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.prefs.BackingStoreException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableModel;

public class ListOfOrdersPane
extends JPanel {
    private static final String STUDY_DATE_KEY = "dateTime";
    private static final String MODALITY_KEY = "modality";
    private static final String STATUS_KEY = "status";
    private static final String EXAM_ID_KEY = "examId";
    private static final String REPORTING_MD_KEY = "reportingMd";
    private static final String REFERRING_PHY_KEY = "referringMd";
    private static final String DESCRIPTION_KEY = "description";
    private static final String STUDY_DATE = "Study Date/Time";
    private static final String MODALITY = "Mod.";
    private static final String STATUS = "Status";
    private static final String EXAM_ID = "Exam";
    private static final String REPORTING_MD = "Reported By";
    private static final String REFERRING_PHY = "Ref. Phys.";
    private static final String DESCRIPTION = "Description";
    private static final int STUDY_DATETIME_INDEX = 0;
    private static final int EXAM_ID_INDEX = 1;
    private static final int MODALITY_INDEX = 2;
    private static final int STATUS_INDEX = 3;
    private static final int REPORTING_MD_INDEX = 4;
    private static final int REFERRING_PHY_INDX = 5;
    private static final int DESCRIPTION_INDEX = 6;
    private static final String COLUMN_ID_KEY = "Column Id";
    private static final String COLUMN_WIDTH_KEY = "Column Width";
    private OrderListTableModel mTableModel;
    private JTable mTableView;
    private JScrollPane mScroller;
    private ReportViewer mReportViewer;
    private String mExamId;
    private String[] mTableColumnNames;
    private final OrderStatusProvider mOrderStatusProvider;

    private final void createTable() {
        this.mTableView = new JTable(this.mTableModel);
        this.mTableView.setBackground(Color.LIGHT_GRAY);
        this.mTableView.addMouseListener(new MouseHandler());
        this.mTableView.addMouseMotionListener(new MouseMotionHandler());
        this.mTableView.addKeyListener(new KeyboardHandler());
        this.mTableView.setAutoCreateColumnsFromModel(false);
        this.sortAllRowsBy(0, false);
        this.mTableView.setSelectionMode(0);
        this.mTableView.setColumnSelectionAllowed(false);
        this.mTableView.setRowSelectionAllowed(true);
        this.updateSelection(this.mExamId);
    }

    private final void viewSelectedOrder() {
        int n = this.mTableView.getSelectedRow();
        if (n >= 0) {
            Rectangle rectangle = this.mTableView.getCellRect(n, 0, true);
            int n2 = Math.max(0, (int)rectangle.getY() - (int)rectangle.getHeight() * 2);
            this.mScroller.getViewport().setViewPosition(new Point(0, n2));
        }
    }

    private final int getExamIdIndex(String string) {
        this.mExamId = string;
        return this.getExamIdIndex();
    }

    private final int getExamIdIndex() {
        if (this.mExamId == null || this.mExamId.length() <= 0) {
            return -1;
        }
        int n = 0;
        while (n < this.mTableModel.getRowCount()) {
            if (this.mTableModel.getExamId(n).equalsIgnoreCase(this.mExamId)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void updateSelection() {
        if (this.mTableView.getRowCount() > 0) {
            int n = this.getExamIdIndex();
            if (n > -1) {
                this.mTableView.setRowSelectionInterval(n, n);
            } else {
                this.mTableView.clearSelection();
            }
        }
    }

    public void updateSelection(String string) {
        if (this.mTableView.getRowCount() > 0) {
            int n = this.getExamIdIndex(string);
            if (n > -1) {
                this.mTableView.setRowSelectionInterval(n, n);
            } else {
                this.mTableView.clearSelection();
            }
        }
    }

    public void sortAllRowsBy(int n, boolean bl) {
        this.mTableModel.sort(n, bl);
        this.mTableModel.fireTableStructureChanged();
    }

    private final void createTableColumnNames(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!StringCheck.isStringEmpty(string)) {
            arrayList.add(string);
        } else {
            arrayList.add(STUDY_DATE);
        }
        arrayList.add(EXAM_ID);
        arrayList.add(MODALITY);
        arrayList.add(STATUS);
        arrayList.add(REPORTING_MD);
        arrayList.add(REFERRING_PHY);
        arrayList.add(DESCRIPTION);
        this.mTableColumnNames = arrayList.toArray(new String[0]);
    }

    private final void addColumnIdentifiers() {
        this.mTableView.getColumnModel().getColumn(0).setIdentifier(STUDY_DATE_KEY);
        this.mTableView.getColumnModel().getColumn(1).setIdentifier(EXAM_ID_KEY);
        this.mTableView.getColumnModel().getColumn(2).setIdentifier(MODALITY_KEY);
        this.mTableView.getColumnModel().getColumn(3).setIdentifier(STATUS_KEY);
        this.mTableView.getColumnModel().getColumn(4).setIdentifier(REPORTING_MD_KEY);
        this.mTableView.getColumnModel().getColumn(5).setIdentifier(REFERRING_PHY_KEY);
        this.mTableView.getColumnModel().getColumn(6).setIdentifier(DESCRIPTION_KEY);
    }

    private final List getColumnPreferenceMaps() {
        ArrayList arrayList = new ArrayList(this.mTableView.getColumnCount());
        int n = 0;
        while (n < this.mTableView.getColumnCount()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            String string = (String)this.mTableView.getColumnModel().getColumn(n).getIdentifier();
            String string2 = Integer.toString(this.mTableView.getColumnModel().getColumn(n).getWidth());
            hashMap.put(COLUMN_ID_KEY, string);
            hashMap.put(COLUMN_WIDTH_KEY, string2);
            arrayList.add(hashMap);
            ++n;
        }
        return arrayList;
    }

    private final int getViewIndexByKey(String string) throws IllegalArgumentException {
        return this.mTableView.getColumnModel().getColumnIndex(string);
    }

    private final void setColumnView() {
        List list = null;
        try {
            list = this.mReportViewer.getUserPreferences().getListOfOrdersColumnPreferences();
        }
        catch (BackingStoreException backingStoreException) {
            DebugManager.getDefault().printException("Error reading Report Viewer List Of Orders preferences", backingStoreException);
            return;
        }
        if (list.size() > this.mTableView.getColumnCount()) {
            DebugManager.getDefault().printError("Report Viewer -> Preference column number exceeds view column number");
            return;
        }
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Map map = (Map)iterator.next();
            try {
                String string = (String)map.get(COLUMN_ID_KEY);
                this.mTableView.moveColumn(this.getViewIndexByKey(string), n);
                int n2 = Integer.valueOf((String)map.get(COLUMN_WIDTH_KEY));
                this.mTableView.getColumnModel().getColumn(n).setPreferredWidth(n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                DebugManager.getDefault().printException("Report Viewer List of Orders Preference column", illegalArgumentException);
            }
            ++n;
        }
    }

    private final void saveColumnInformation() {
        try {
            this.mReportViewer.getUserPreferences().setListOfOrdersColumnPreferences(this.getColumnPreferenceMaps());
        }
        catch (BackingStoreException backingStoreException) {
            DebugManager.getDefault().printException("Error writing Report Viewer List Of Orders preferences", backingStoreException);
        }
    }

    public ListOfOrdersPane(ReportViewer reportViewer, OrderHeaderList orderHeaderList, String string, boolean bl, OrderStatusProvider orderStatusProvider) {
        this.mReportViewer = reportViewer;
        this.mExamId = string;
        this.mOrderStatusProvider = orderStatusProvider;
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(), " List of Orders ");
        this.createTableColumnNames(orderHeaderList.getStudyDateLabel());
        this.setLayout(new BorderLayout());
        titledBorder.setTitleFont(new Font("Helvetica", 1, 14));
        this.setBorder(titledBorder);
        this.mTableModel = new OrderListTableModel(orderHeaderList.getOrderHeaderList(), this.mTableColumnNames, bl);
        this.createTable();
        this.addColumnIdentifiers();
        this.mScroller = new JScrollPane(this.mTableView);
        this.mScroller.setPreferredSize(new Dimension(0, 100));
        this.add("Center", this.mScroller);
        this.viewSelectedOrder();
        this.setColumnView();
        this.mTableView.getColumnModel().addColumnModelListener(new TableColumnModelHandler());
    }

    private class OrderListTableModel
    extends DefaultTableModel {
        private List mOrderHeaderList;
        private String[] mColumnNames;
        private boolean mIheMode;

        private final int compareOrderHeaders(OrderHeader orderHeader, OrderHeader orderHeader2, int n) {
            switch (n) {
                case 0: {
                    return ReportViewerUtil.compareOrderDateTimes(orderHeader, orderHeader2);
                }
                case 1: {
                    return this.compareStrings(orderHeader.getAccession(), orderHeader2.getAccession());
                }
                case 2: {
                    return this.compareStrings(orderHeader.getModality(), orderHeader2.getModality());
                }
                case 3: {
                    return this.compareStrings(ListOfOrdersPane.this.mOrderStatusProvider.getStatus(orderHeader), ListOfOrdersPane.this.mOrderStatusProvider.getStatus(orderHeader2));
                }
                case 4: {
                    return this.compareStrings(orderHeader.getReportingMd(), orderHeader2.getReportingMd());
                }
                case 5: {
                    return this.compareStrings(orderHeader.getReferringPhysician(), orderHeader2.getReferringPhysician());
                }
                case 6: {
                    return this.compareStrings(orderHeader.getDescription(), orderHeader2.getDescription());
                }
            }
            return 0;
        }

        private final int compareStrings(String string, String string2) {
            if (string == null && string2 == null) {
                return 0;
            }
            if (string == null) {
                return 1;
            }
            if (string2 == null) {
                return -1;
            }
            return string.compareTo(string2);
        }

        public void sort(int n, boolean bl) {
            Comparator comparator = new Comparator(this, bl, n){
                int ascendingFactor;
                final /* synthetic */ OrderListTableModel this$0;
                final /* synthetic */ boolean val$ascending;
                final /* synthetic */ int val$column;

                public final int compare(Object object, Object object2) {
                    OrderHeader orderHeader = (OrderHeader)object;
                    OrderHeader orderHeader2 = (OrderHeader)object2;
                    int n = OrderListTableModel.access$0(this.this$0, orderHeader, orderHeader2, this.val$column);
                    if (n == 0) {
                        return this.ascendingFactor * -1;
                    }
                    return this.ascendingFactor * n;
                }

                private final /* synthetic */ void this() {
                    this.ascendingFactor = this.val$ascending ? 1 : -1;
                }
                {
                    this.this$0 = orderListTableModel;
                    this.val$ascending = bl;
                    this.val$column = n;
                    this.this();
                }
            };
            TreeSet treeSet = new TreeSet(comparator);
            treeSet.addAll(this.mOrderHeaderList);
            this.mOrderHeaderList.clear();
            this.mOrderHeaderList.addAll(treeSet);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public String getColumnName(int n) {
            return this.mColumnNames[n];
        }

        public OrderHeader getOrderHeader(int n) {
            return (OrderHeader)this.mOrderHeaderList.get(n);
        }

        public String getExamId(int n) {
            OrderHeader orderHeader = this.getOrderHeader(n);
            return this.mIheMode ? orderHeader.getPacsKey() : orderHeader.getAccession();
        }

        public Object getValueAt(int n, int n2) {
            OrderHeader orderHeader = (OrderHeader)this.mOrderHeaderList.get(n);
            switch (n2) {
                case 0: {
                    return ReportViewer.formatOrderHeaderStudyDateTime(orderHeader, null);
                }
                case 1: {
                    return this.mIheMode ? orderHeader.getPacsKey() : orderHeader.getAccession();
                }
                case 2: {
                    return orderHeader.getModality();
                }
                case 3: {
                    return ListOfOrdersPane.this.mOrderStatusProvider.getStatus(orderHeader);
                }
                case 4: {
                    return orderHeader.getReportingMd();
                }
                case 5: {
                    return orderHeader.getReferringPhysician();
                }
                case 6: {
                    return orderHeader.getDescription();
                }
            }
            return null;
        }

        static /* synthetic */ int access$0(OrderListTableModel orderListTableModel, OrderHeader orderHeader, OrderHeader orderHeader2, int n) {
            return orderListTableModel.compareOrderHeaders(orderHeader, orderHeader2, n);
        }

        public OrderListTableModel(List list, String[] stringArray, boolean bl) {
            super(list.size(), stringArray.length);
            this.mOrderHeaderList = list;
            this.mColumnNames = stringArray;
            this.mIheMode = bl;
        }
    }

    class MouseHandler
    extends MouseAdapter {
        public void mouseClicked(MouseEvent mouseEvent) {
            int n = ListOfOrdersPane.this.mTableView.rowAtPoint(mouseEvent.getPoint());
            ListOfOrdersPane.this.mExamId = ListOfOrdersPane.this.mTableModel.getExamId(n);
            ListOfOrdersPane.this.mReportViewer.getReportsPane().update(ListOfOrdersPane.this.mExamId);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n = ListOfOrdersPane.this.mTableView.rowAtPoint(mouseEvent.getPoint());
            ListOfOrdersPane.this.mExamId = ListOfOrdersPane.this.mTableModel.getExamId(n);
            ListOfOrdersPane.this.mReportViewer.getReportsPane().update(ListOfOrdersPane.this.mExamId);
        }

        MouseHandler() {
        }
    }

    class MouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = ListOfOrdersPane.this.mTableView.rowAtPoint(mouseEvent.getPoint());
            if (n >= 0 && n < ListOfOrdersPane.this.mTableView.getRowCount()) {
                ListOfOrdersPane.this.mExamId = ListOfOrdersPane.this.mTableModel.getExamId(n);
                ListOfOrdersPane.this.mReportViewer.getReportsPane().update(ListOfOrdersPane.this.mExamId);
            }
        }

        MouseMotionHandler() {
        }
    }

    class KeyboardHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            int n2 = ListOfOrdersPane.this.mTableView.getRowCount();
            if (keyEvent.getKeyCode() == 38) {
                int n3 = ListOfOrdersPane.this.mTableView.getSelectedRow();
                if (n3 > 0) {
                    ListOfOrdersPane.this.mExamId = ListOfOrdersPane.this.mTableModel.getExamId(--n3);
                    ListOfOrdersPane.this.mReportViewer.getReportsPane().update(ListOfOrdersPane.this.mExamId);
                }
            } else if (keyEvent.getKeyCode() == 40 && (n = ListOfOrdersPane.this.mTableView.getSelectedRow()) != n2 - 1) {
                ListOfOrdersPane.this.mExamId = ListOfOrdersPane.this.mTableModel.getExamId(++n);
                ListOfOrdersPane.this.mReportViewer.getReportsPane().update(ListOfOrdersPane.this.mExamId);
            }
        }

        KeyboardHandler() {
        }
    }

    class TableColumnModelHandler
    implements TableColumnModelListener {
        public void columnMarginChanged(ChangeEvent changeEvent) {
            ListOfOrdersPane.this.saveColumnInformation();
        }

        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            ListOfOrdersPane.this.saveColumnInformation();
        }

        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        TableColumnModelHandler() {
        }
    }
}

