/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Layouts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ConstraintLayout
implements LayoutManager2 {
    protected static final int PREFERRED = 0;
    protected static final int MINIMUM = 1;
    protected static final int MAXIMUM = 2;
    protected int hMargin;
    protected int vMargin;
    private Hashtable constraints;
    protected boolean includeInvisible;

    public void addLayoutComponent(String string, Component component) {
        this.setConstraint(component, string);
    }

    public void addLayoutComponent(Component component, Object object) {
        this.setConstraint(component, object);
    }

    public void removeLayoutComponent(Component component) {
        if (this.constraints != null) {
            this.constraints.remove(component);
        }
    }

    public void setConstraint(Component component, Object object) {
        if (object != null) {
            if (this.constraints == null) {
                this.constraints = new Hashtable();
            }
            this.constraints.put(component, object);
        } else if (this.constraints != null) {
            this.constraints.remove(component);
        }
    }

    public Object getConstraint(Component component) {
        if (this.constraints != null) {
            return this.constraints.get(component);
        }
        return null;
    }

    public void setIncludeInvisible(boolean bl) {
        this.includeInvisible = bl;
    }

    public boolean getIncludeInvisible() {
        return this.includeInvisible;
    }

    protected boolean includeComponent(Component component) {
        boolean bl = false;
        if (this.includeInvisible || component.isVisible()) {
            bl = true;
        }
        return bl;
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calcLayoutSize(container, 1);
    }

    public Dimension maximumLayoutSize(Container container) {
        return this.calcLayoutSize(container, 2);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calcLayoutSize(container, 0);
    }

    public Dimension calcLayoutSize(Container container, int n) {
        Dimension dimension = new Dimension(0, 0);
        this.measureLayout(container, dimension, n);
        Insets insets = container.getInsets();
        dimension.width += insets.left + insets.right + 2 * this.hMargin;
        dimension.height += insets.top + insets.bottom + 2 * this.vMargin;
        return dimension;
    }

    public void invalidateLayout(Container container) {
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.5f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.5f;
    }

    public void layoutContainer(Container container) {
        this.measureLayout(container, null, 0);
    }

    public void measureLayout(Container container, Dimension dimension, int n) {
    }

    protected Dimension getComponentSize(Component component, int n) {
        if (n == 1) {
            return component.getMinimumSize();
        }
        if (n == 2) {
            return component.getMaximumSize();
        }
        return component.getPreferredSize();
    }

    private final /* synthetic */ void this() {
        this.hMargin = 0;
        this.vMargin = 0;
        this.includeInvisible = false;
    }

    public ConstraintLayout() {
        this.this();
    }
}

