/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Icon;

import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.ImageIcon;

public class IconCache {
    private HashMap mIconHashMap = new HashMap();
    private HashMap mIconFileNameToSize = new HashMap();

    public ImageIcon getImageIcon(String string) {
        ImageIcon imageIcon = null;
        if (this.mIconFileNameToSize.containsKey(string)) {
            Dimension dimension = (Dimension)this.mIconFileNameToSize.get(string);
            imageIcon = (ImageIcon)this.mIconHashMap.get(new IconHashKey(string, dimension.width, dimension.height));
        } else {
            imageIcon = new ImageIcon(this.getClass().getResource(string));
            this.addNativeImageSize(string, imageIcon);
        }
        return imageIcon;
    }

    public ImageIcon getImageIcon(String string, int n, int n2) {
        IconHashKey iconHashKey = new IconHashKey(string, n, n2);
        ImageIcon imageIcon = (ImageIcon)this.mIconHashMap.get(iconHashKey);
        if (imageIcon != null) {
            return imageIcon;
        }
        imageIcon = new ImageIcon(this.getClass().getResource(string));
        if (n == imageIcon.getIconWidth() && n2 == imageIcon.getIconHeight()) {
            this.addNativeImageSize(string, imageIcon);
        } else {
            imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(n, n2, 4));
            this.mIconHashMap.put(iconHashKey, imageIcon);
        }
        return imageIcon;
    }

    private final void addNativeImageSize(String string, ImageIcon imageIcon) {
        this.mIconFileNameToSize.put(string, new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.mIconHashMap.put(new IconHashKey(string, imageIcon.getIconWidth(), imageIcon.getIconHeight()), imageIcon);
    }

    private static class IconHashKey {
        private final String mIconName;
        private final int mXSize;
        private final int mYSize;

        public int hashCode() {
            return this.mIconName.hashCode() ^ this.mXSize ^ (this.mYSize << 16 | this.mYSize >>> 16);
        }

        public boolean equals(Object object) {
            if (!(object instanceof IconHashKey)) {
                return false;
            }
            IconHashKey iconHashKey = (IconHashKey)object;
            boolean bl = false;
            if (this.mIconName.equals(iconHashKey.mIconName) && this.mXSize == iconHashKey.mXSize && this.mYSize == iconHashKey.mYSize) {
                bl = true;
            }
            return bl;
        }

        public IconHashKey(String string, int n, int n2) {
            this.mIconName = string;
            this.mXSize = n;
            this.mYSize = n2;
        }
    }
}

