/*
 * Decompiled with CFR 0.152.
 */
package GuiUtilities.Dialog;

import GuiUtilities.Util.GuiUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;

public abstract class ProgressDialog
extends JWindow
implements ActionListener {
    private JButton mCancelButton;
    private JProgressBar mProgressBar;

    private final Component createCancelButton() {
        this.mCancelButton = new JButton("Cancel");
        this.mCancelButton.addActionListener(this);
        Box box = new Box(0);
        box.setBorder(new EmptyBorder(8, 8, 8, 8));
        box.add(Box.createGlue());
        box.add(this.mCancelButton);
        box.add(Box.createGlue());
        return box;
    }

    protected JProgressBar createProgressBar(String string) {
        JProgressBar jProgressBar = new JProgressBar();
        jProgressBar.setEnabled(true);
        jProgressBar.setStringPainted(true);
        jProgressBar.setIndeterminate(true);
        jProgressBar.setBorderPainted(true);
        jProgressBar.setString(string);
        return jProgressBar;
    }

    public void dispose() {
        this.mProgressBar.setIndeterminate(false);
        super.dispose();
    }

    public static ProgressDialog createUncancellableProgressDialog(Window window, ImageIcon imageIcon, String string) {
        return new ProgressDialog(window, imageIcon, string, false){

            protected final void cancel() {
            }
        };
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.mCancelButton) {
            this.cancel();
            this.dispose();
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(300, 125);
    }

    protected abstract void cancel();

    public ProgressDialog(Window window, ImageIcon imageIcon, String string) {
        this(window, imageIcon, string, true);
    }

    private ProgressDialog(Window window, ImageIcon imageIcon, String string, boolean bl) {
        super(window);
        if (window != null) {
            window.setEnabled(false);
        }
        this.setBackground(Color.ORANGE);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBackground(Color.ORANGE);
        jPanel.setBorder(new LineBorder(Color.BLACK, 5, true));
        jPanel.add("Center", new JLabel(imageIcon));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.mProgressBar = this.createProgressBar(string);
        jPanel2.add("North", this.mProgressBar);
        if (bl) {
            jPanel2.add("South", this.createCancelButton());
        }
        jPanel.add("South", jPanel2);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add("Center", jPanel);
        this.pack();
        if (window != null) {
            GuiUtilities.centerWindowOnParent(window, this);
        }
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ ProgressDialog this$0;

            public final void windowClosed(WindowEvent windowEvent) {
                this.this$0.getOwner().setEnabled(true);
            }
            {
                this.this$0 = progressDialog;
            }
        });
        this.addComponentListener(new ComponentAdapter(this){
            final /* synthetic */ ProgressDialog this$0;

            public final void componentHidden(ComponentEvent componentEvent) {
                this.this$0.getOwner().setEnabled(true);
            }
            {
                this.this$0 = progressDialog;
            }
        });
    }
}

