/*
 * Decompiled with CFR 0.152.
 */
package Gui;

import Gui.ArgumentParser;
import GuiUtilities.Icon.IconCache;
import ReportViewerLibrary.Preferences.ReportViewerPreferenceProvider;
import RuntimeTool.Debug;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;

public class GlobalState {
    private static final String DEBUG_KEY_TRACE = "TRACE|WARNING";
    private static final String LOAD_USER_PATH = "/XmlDataServlet/XmlDataServlet.Execute?action=getUser";
    static final String APPLICATION_NAME = "ReportViewerClient";
    protected static ArgumentParser mArgumentParser = null;
    protected static ReportViewerPreferenceProvider mPreferenceProvider = null;
    protected static Debug mDebug = null;
    protected static IconCache mIconCache = null;
    protected static boolean mHideGui = false;
    protected static boolean mReadyToExit = false;
    protected static boolean mServerChanged = true;

    static Debug getDebug() {
        return mDebug;
    }

    public static void debug(String string) {
        mDebug.print("DEBUG", string);
    }

    public static void trace(String string) {
        mDebug.print("TRACE", string);
    }

    public static void error(String string) {
        GlobalState.error(string, null);
    }

    public static void error(String string, Throwable throwable) {
        mDebug.printError(string);
        if (throwable != null) {
            mDebug.printStackTrace(throwable);
        }
    }

    public static ImageIcon getImageIcon(String string) {
        return mIconCache.getImageIcon(string);
    }

    public static ImageIcon getImageIcon(String string, int n, int n2) {
        return new ImageIcon(GlobalState.getImageIcon(string).getImage().getScaledInstance(n, n2, 4));
    }

    public static void setPreferenceProvider(ReportViewerPreferenceProvider reportViewerPreferenceProvider) {
        mPreferenceProvider = reportViewerPreferenceProvider;
    }

    public static ReportViewerPreferenceProvider getPreferenceProvider() {
        return mPreferenceProvider;
    }

    public static void setArgumentParser(ArgumentParser argumentParser) {
        mServerChanged = GlobalState.hasServerChanged(argumentParser);
        mArgumentParser = argumentParser;
    }

    public static ArgumentParser getArgumentParser() {
        return mArgumentParser;
    }

    public static void setReadyToExit(boolean bl) {
        mReadyToExit = bl;
    }

    public static boolean isReadyToExit() {
        return mReadyToExit;
    }

    public static void setHideGui(boolean bl) {
        mHideGui = bl;
    }

    public static boolean getHideGui() {
        return mHideGui;
    }

    public static URL getLoadUserUrlBase() {
        try {
            URL uRL = new URL(mArgumentParser.getXmlDataServletUrl());
            String string = "/XmlDataServlet/XmlDataServlet.Execute?action=getUser&username=" + mArgumentParser.getUsername() + "&macAddress=" + mArgumentParser.getMacAddress() + "&clientId=ReportViewerClient_REPORT_VIEWER_CLIENT-VER-1-9-8-P2_PACS-3-4-1-P107";
            return new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public static boolean getServerChanged() {
        return mServerChanged;
    }

    private static final boolean hasServerChanged(ArgumentParser argumentParser) {
        try {
            if (mArgumentParser == null) {
                return true;
            }
            if (GlobalState.isReadyToExit()) {
                return true;
            }
            URL uRL = new URL(mArgumentParser.getXmlDataServletUrl());
            URL uRL2 = new URL(argumentParser.getXmlDataServletUrl());
            boolean bl = false;
            if (!uRL2.getHost().equals(uRL.getHost()) || uRL2.getPort() != uRL.getPort()) {
                bl = true;
            }
            return bl;
        }
        catch (MalformedURLException malformedURLException) {
            GlobalState.error("In hasServerChanged(): got MalformedURLException while trying to compare previous XmlDataServlet URL [" + mArgumentParser.getXmlDataServletUrl() + "] and new XmlDataServlet URL [" + argumentParser.getXmlDataServletUrl() + "].");
            return true;
        }
    }

    static {
        mDebug = new Debug(APPLICATION_NAME, "stdout", DEBUG_KEY_TRACE);
        mIconCache = new IconCache();
    }
}

